% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depRule.R
\name{depRule}
\alias{depRule}
\title{A rule that defines a dependency between targets without actually providing
any execution script.}
\usage{
depRule(target, depends = NULL, task = "all")
}
\arguments{
\item{target}{Target file name that depends on \code{depends}}

\item{depends}{A character vector of prerequisite file names that \code{target} depends on.}

\item{task}{A character vector of parent task names. The mechanism of tasks
allows to group rules. Anything different from \code{'all'} will
cause creation of a new task depending on the given rule.
Executing \verb{make taskname} will then force building of this rule.}
}
\value{
Instance of S3 class \code{rmake.rule}
}
\description{
This rule is useful when you want to specify that a target depends on
another target, but you do not want to execute any script to build it.
}
\seealso{
\code{\link[=rule]{rule()}}, \code{\link[=makefile]{makefile()}}
}
\author{
Michal Burda
}
