% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_collection.R
\name{get_collection}
\alias{get_collection}
\alias{get_collection.default}
\alias{get_collection.mgSearchDatasets}
\alias{get_collection.mgSearchNetworks}
\alias{get_collection.mgSearchReferences}
\alias{get_collection.mgSearchNodes}
\alias{get_collection.mgSearchTaxonomy}
\alias{get_collection.mgSearchInteractions}
\title{Get a collection of networks}
\usage{
get_collection(x, ...)

\method{get_collection}{default}(x, ...)

\method{get_collection}{mgSearchDatasets}(x, ...)

\method{get_collection}{mgSearchNetworks}(x, ...)

\method{get_collection}{mgSearchReferences}(x, ...)

\method{get_collection}{mgSearchNodes}(x, ...)

\method{get_collection}{mgSearchTaxonomy}(x, ...)

\method{get_collection}{mgSearchInteractions}(x, ...)
}
\arguments{
\item{x}{\code{numeric} vector of Mangal network IDs or an object returned by
by one of the \verb{search_*()} functions.}

\item{...}{arguments to be passed on to \code{\link[=get_network_by_id]{get_network_by_id()}}.}
}
\value{
Returns a object of class \code{mgNetworksCollection} which is a collection
(actually, a list) of \code{mgNetwork} objects \code{\link[=get_network_by_id]{get_network_by_id()}}).
}
\description{
Retrieve a set of networks based on the results of one of the \verb{search_*()}
function. The function also accepts a numeric vector of Mangal network IDs.
}
\section{Methods (by class)}{
\itemize{
\item \code{get_collection(default)}: Get a collection of networks (default).

\item \code{get_collection(mgSearchDatasets)}: Get a collection of networks from a \code{mgSearchDatasets} object.

\item \code{get_collection(mgSearchNetworks)}: Get a collection of networks from a \code{mgSearchNetworks} object.

\item \code{get_collection(mgSearchReferences)}: Get a collection of networks from a \code{mgSearchReferences} object.

\item \code{get_collection(mgSearchNodes)}: Get a collection of networks from a \code{mgSearchNodes} object.

\item \code{get_collection(mgSearchTaxonomy)}: Get a collection of networks from a \code{mgSearchTaxa} object.

\item \code{get_collection(mgSearchInteractions)}: Get a collection of networks from a \code{mgSearchTaxa} object.

}}
\examples{
\donttest{
 mg_2 <- get_collection(c(1076:1077), verbose = FALSE)
 mg_anemone <- get_collection(search_networks(query='anemone\%'), verbose = FALSE)
}
}
\seealso{
\code{\link[=search_datasets]{search_datasets()}}, \code{\link[=search_interactions]{search_interactions()}}, \code{\link[=search_networks]{search_networks()}},
\code{\link[=search_nodes]{search_nodes()}}, \code{\link[=search_references]{search_references()}}, \code{\link[=search_taxonomy]{search_taxonomy()}}.
}
