% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz-autocomplete.R, R/mz-reverse.R,
%   R/mz-search.R
\name{mz_autocomplete}
\alias{mz_autocomplete}
\alias{mz_reverse_geocode}
\alias{search}
\alias{mz_search}
\title{Mapzen search API}
\usage{
mz_autocomplete(text, boundary.country = NULL, boundary.rect = NULL,
  focus.point = NULL, sources = NULL, layers = NULL, api_key = NULL)

mz_reverse_geocode(point, size = NULL, layers = NULL, sources = NULL,
  boundary.country = NULL, api_key = NULL)

mz_search(text, size = 10, boundary.country = NULL, boundary.rect = NULL,
  boundary.circle = NULL, focus.point = NULL, sources = NULL,
  layers = NULL, api_key = NULL)
}
\arguments{
\item{text}{Search string}

\item{boundary.country}{ISO-3166 country code to narrow the search.
See \code{\link{mz_countries}}}

\item{boundary.rect}{4 corners that define a box to narrow the search. Can
be the result of \code{\link{mz_bbox}}. Should have named elements with names
"min_lon", "min_lat", "max_lon", "max_lat" -- can be created using \code{\link{mz_rect}}.}

\item{focus.point}{A point to "focus" the search. Can be created with
\code{\link{mz_location}} or \code{\link{mz_geocode}}, otherwise should have
 names "lat" and "lon"}

\item{sources}{The originating source of the data (to filter/narrow search
results). See \code{\link{mz_sources}}}

\item{layers}{Which layers (types of places) to search. See
\url{https://mapzen.com/documentation/search/search/#filter-by-data-type}
for definitions, and use \code{\link{mz_layers}} for convenience}

\item{api_key}{Your Mapzen API key. The default is to look for the key within
the provider information that was set up with `mz_set_host`.}

\item{point}{For reverse geocoding, the location to reverse geocode. Can be
created with \code{\link{mz_location}} or \code{\link{mz_geocode}},
otherwise should have names "lat" and "lon"}

\item{size}{Number of search results requested}

\item{boundary.circle}{A circle to narrow the search. Should have named elements
with names "lon", "lat", and "radius"}
}
\description{
Functions to access the various endpoints from the Mapzen Search API.
For more details, see \url{https://mapzen.com/documentation/search/}. If your
data is already split up by street, city, state, zip, etc., then you might
find \code{\link{mz_structured_search}} to be more precise. All arguments
besides \code{text} (\code{point} in the case of \code{mz_reverse_geocode}) are
optional. If you have parsed addresses (e.g. for geocoding), use \code{\link{mz_structured_search}}
}
\examples{
\dontrun{
# hard rock cafes in sweden:
mz_search("Hard Rock Cafe", boundary.country = "SE")

# autocompletions when the user types in "Union Square"
# prioritizing San Francisco results first:
mz_autocomplete("Union Square",
                focus.point = mz_geocode("San Francisco, CA"))
}

}
\seealso{
\code{\link{mz_place}}, \code{\link{mz_structured_search}},
\code{\link{mz_countries}}, \code{\link{mz_sources}}, \code{\link{mz_layers}}
}
