% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slidy_presentation.R
\name{slidy_presentation}
\alias{slidy_presentation}
\title{Convert to a slidy presentation}
\usage{
slidy_presentation(
  incremental = FALSE,
  duration = NULL,
  footer = NULL,
  font_adjustment = 0,
  fig_width = 8,
  fig_height = 6,
  fig_retina = 2,
  fig_caption = TRUE,
  dev = "png",
  df_print = "default",
  smart = TRUE,
  self_contained = TRUE,
  highlight = "default",
  mathjax = "default",
  template = "default",
  css = NULL,
  includes = NULL,
  keep_md = FALSE,
  lib_dir = NULL,
  md_extensions = NULL,
  pandoc_args = NULL,
  extra_dependencies = NULL,
  ...
)
}
\arguments{
\item{incremental}{\code{TRUE} to render slide bullets incrementally. Note
that if you want to reverse the default incremental behavior for an
individual bullet you can precede it with \code{>}. For example:
\emph{\code{> - Bullet Text}}}

\item{duration}{Duration (in minutes) of the slide deck. This value is used
to add a countdown timer to the slide footer.}

\item{footer}{Footer text (e.g. organization name and/or copyright)}

\item{font_adjustment}{Increase or decrease the default font size (e.g. -1 or
+1). You can also manually adjust the font size during the presentation
using the 'S' (smaller) and 'B' (bigger) keys.}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays (defaults to 2, which
currently works for all widely used retina displays). Set to \code{NULL} to
prevent retina scaling. Note that this will always be \code{NULL} when
\code{keep_md} is specified (this is because \code{fig_retina} relies on
outputting HTML directly into the markdown document).}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{dev}{Graphics device to use for figure output (defaults to pdf)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses \code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}.}

\item{smart}{Produce typographically correct output, converting straight
quotes to curly quotes, \code{---} to em-dashes, \code{--} to en-dashes, and
\code{...} to ellipses.}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
its size).}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", and "haddock". Pass \code{NULL} to prevent syntax highlighting.}

\item{mathjax}{Include mathjax. The "default" option uses an https URL from a
MathJax CDN. The "local" option uses a local version of MathJax (which is
copied into the output directory). You can pass an alternate URL or pass
\code{NULL} to exclude MathJax entirely.}

\item{template}{Pandoc template to use for rendering. Pass "default" to use
the rmarkdown package default template; pass \code{NULL} to use pandoc's
built-in template; pass a path to use a custom template that you've
created.  See the documentation on
\href{http://pandoc.org/README.html}{pandoc online documentation}
for details on creating custom templates.}

\item{css}{One or more css files to include}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{lib_dir}{Directory to copy dependent HTML libraries (e.g. jquery,
bootstrap, etc.) into. By default this will be the name of the document with
\code{_files} appended to it.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{extra_dependencies}{A LaTeX dependency \code{latex_dependency()}, a
list of LaTeX dependencies, a character vector of LaTeX package names (e.g.
\code{c("framed", "hyperref")}), or a named list of LaTeX package options
with the names being package names (e.g. \code{list(hypreref =
c("unicode=true", "breaklinks=true"), lmodern = NULL)}). It can be used to
add custom LaTeX packages to the .tex header.}

\item{...}{Additional function arguments to pass to the base R Markdown HTML
output formatter \code{\link{html_document_base}}}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to a slidy presentation.
}
\details{
See the \href{https://rmarkdown.rstudio.com/slidy_presentation_format.html}{online
documentation} for additional details on using the \code{slidy_presentation}
format.

For more information on markdown syntax for presentations see the
\href{https://pandoc.org/README.html}{pandoc online documentation}.
}
\examples{
\dontrun{
library(rmarkdown)

# simple invocation
render("pres.Rmd", slidy_presentation())

# specify an option for incremental rendering
render("pres.Rmd", slidy_presentation(incremental = TRUE))
}
}
