% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_document.R
\name{github_document}
\alias{github_document}
\title{Convert to GitHub Flavored Markdown}
\usage{
github_document(
  toc = FALSE,
  toc_depth = 3,
  number_sections = FALSE,
  math_method = "webtex",
  preserve_yaml = FALSE,
  fig_width = 7,
  fig_height = 5,
  dev = "png",
  df_print = "default",
  includes = NULL,
  md_extensions = NULL,
  hard_line_breaks = TRUE,
  pandoc_args = NULL,
  html_preview = TRUE,
  keep_html = FALSE
)
}
\arguments{
\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_depth}{Depth of headers to include in table of contents}

\item{number_sections}{\code{TRUE} to number section headings}

\item{math_method}{\code{"webtex"} (the default) is used to render equations. This
will insert math an image in the resulting Markdown. See \code{\link[=html_document]{html_document()}}
for option to change webtex URL. Set to \code{NULL} to opt-out.}

\item{preserve_yaml}{Preserve YAML front matter in final document.}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{dev}{Graphics device to use for figure output (defaults to png)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses a corresponding S3 method of \code{print}, typically
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}. See
\href{https://bookdown.org/yihui/rmarkdown/html-document.html#data-frame-printing}{Data
frame printing section} in bookdown book for examples.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition of R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{hard_line_breaks}{\code{TRUE} to generate markdown that uses a simple
newline to represent a line break (as opposed to two-spaces and a newline).}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{html_preview}{\code{TRUE} to also generate an HTML file for the purpose of
locally previewing what the document will look like on GitHub.}

\item{keep_html}{\code{TRUE} to keep the preview HTML file in the working
directory. Default is \code{FALSE}.}
}
\value{
R Markdown output format to pass to \code{\link[=render]{render()}}
}
\description{
Format for converting from R Markdown to GitHub Flavored Markdown.
}
\details{
See the \href{https://rmarkdown.rstudio.com/github_document_format.html}{online documentation} for additional details on using the \code{github_document()}
format.
}
\section{About Math support}{
For Github Markdown output, PNG images with a white background are used so
that it shows correctly on Github on both light and dark theme. You can
choose to only output SVG for better quality by changing the URL used:\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{output:
  github_document:
    math_method:
      engine: webtex
      url: https://latex.codecogs.com/svg.image?
}\if{html}{\out{</div>}}

Background or fonts color cannot be changed for now and your equation may not be visible on dark theme.
}

