% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-table.R
\name{model_table_helpers}
\alias{model_table_helpers}
\alias{attach_data}
\alias{flatten_models}
\title{Model table helper functions}
\usage{
attach_data(x, data, ...)

flatten_models(x, exponentiate = FALSE, which = NULL, ...)
}
\arguments{
\item{x}{A \code{mdl_tbl} object}

\item{data}{A \code{data.frame} object that has been used by models}

\item{...}{Arguments to be passed to or from other methods}

\item{exponentiate}{A \code{logical} value that determines whether to exponentiate
the estimates of the models. Default is \code{FALSE}. If \code{TRUE}, the user can specify
which models to exponentiate by name using the \strong{which} argument.}

\item{which}{A \code{character} vector of model names to exponentiate. Default is \code{NULL}. If \strong{exponentiate} is set to \code{TRUE} and \strong{which} is set to \code{NULL}, then all estimates will be exponentiated, which is often a \emph{bad idea}.}
}
\value{
When using \code{attach_data()}, this returns a modified version of the
\code{mdl_tbl} object however with the dataset attached. When using the
\code{flatten_models()} function, this returns a simplified \code{data.frame} of the
original model table that contains the model-level and parameter-level
statistics.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

These functions are used to help manage the \code{mdl_tbl} object. They allow
for specific manipulation of the internal components, and are intended to
generally extend the functionality of the object.
\itemize{
\item \code{attach_data()}: Attaches a dataset to a \code{mdl_tbl} object
\item \code{flatten_models()}: Flattens a \code{mdl_tbl} object down to its specific parameters
}
}
\section{Attaching Data}{
When models are built, oftentimes the included matrix of data is available
within the raw model, however when handling many models, this can be
expensive in terms of memory and space. By attaching datasets independently
that persist regardless of the underlying models, and by knowing which models
used which datasets, it can be ease to back-transform information.
}

\section{Flattening Models}{
A \code{mdl_tbl} object can be flattened to its specific parameters, their
estimates, and model-level summary statistics. This function additionally
helps by allowing for exponentiation of estimates when deemed appropriate.
The user can specify which models to exponentiate by name. This heavily
relies on the \code{\link[broom:reexports]{broom::tidy()}} functionality.
}

