% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssignItem.R
\name{AssignItem}
\alias{AssignItem}
\title{Assignment Items}
\description{
Assign values to variables in MiniZinc
by creating an assignment item.
}
\section{Super class}{
\code{\link[rminizinc:Item]{rminizinc::Item}} -> \code{AssignItem}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.decl}}{associated declaration}

\item{\code{.e}}{value to be assigned}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.decl}}{associated declaration}

\item{\code{.e}}{value to be assigned}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AssignItem$new()}}
\item \href{#method-id}{\code{AssignItem$id()}}
\item \href{#method-getValue}{\code{AssignItem$getValue()}}
\item \href{#method-setValue}{\code{AssignItem$setValue()}}
\item \href{#method-getDecl}{\code{AssignItem$getDecl()}}
\item \href{#method-setDecl}{\code{AssignItem$setDecl()}}
\item \href{#method-c_str}{\code{AssignItem$c_str()}}
\item \href{#method-getDeleteFlag}{\code{AssignItem$getDeleteFlag()}}
\item \href{#method-delete}{\code{AssignItem$delete()}}
\item \href{#method-clone}{\code{AssignItem$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$new(decl, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{decl}}{declaration associated with assignment.}

\item{\code{value}}{expression to be assigned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-id"></a>}}
\if{latex}{\out{\hypertarget{method-id}{}}}
\subsection{Method \code{id()}}{
get the name of assigned variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getValue"></a>}}
\if{latex}{\out{\hypertarget{method-getValue}{}}}
\subsection{Method \code{getValue()}}{
get the value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$getValue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setValue"></a>}}
\if{latex}{\out{\hypertarget{method-setValue}{}}}
\subsection{Method \code{setValue()}}{
set the value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$setValue(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{value/expression to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDecl"></a>}}
\if{latex}{\out{\hypertarget{method-getDecl}{}}}
\subsection{Method \code{getDecl()}}{
get the associated declaration
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$getDecl()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDecl"></a>}}
\if{latex}{\out{\hypertarget{method-setDecl}{}}}
\subsection{Method \code{setDecl()}}{
set the associated declaration
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$setDecl(decl)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{decl}}{declaration to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
get the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssignItem$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
