% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nassqs.R
\name{nassqs_parse}
\alias{nassqs_parse}
\title{Parse the returned request.}
\usage{
nassqs_parse(req, as = c("data.frame", "list", "raw"), ...)
}
\arguments{
\item{req}{the GET request from \code{\link{nassqs_GET}}.}

\item{as}{indicates type of data returned.}

\item{...}{additional parameters passed to \code{jsonlite::fromJSON} or 
\code{read.table}.}
}
\value{
a data frame or raw text of the content from the request.
}
\description{
Returns a data frame. All values are strings.
}
\examples{
\donttest{
# Set parameters and make the request
params = list(commodity_name="CORN", 
              year=2012, 
              agg_level_desc = "STATE",
              state_alpha = "WA",
              statisticcat_desc = "YIELD")
req <- nassqs_GET(params)
nassqs_parse(req, as = "data.frame")

# Return the request results as a raw string
nassqs_parse(req, as = "raw")
}
}
