% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_rates.R
\name{get_last_n_exchangerates}
\alias{get_last_n_exchangerates}
\title{Retrieves the last n exchange rates.}
\usage{
get_last_n_exchangerates(table, currency_code, n)
}
\arguments{
\item{table}{specifies which from which table the exchange
rate should be fetched.}

\item{currency_code}{code of the currency for which the
exchange rate should be fetched.}

\item{n}{number of exchange rates to retrieve.}
}
\value{
nbp_api_response object containing the last n
exchange rates.
}
\description{
Retrieves the last n exchange rates.
}
\examples{

\donttest{
  tryCatch({
      ## Fetch the last 3 exhange rates for euros
      response <- get_last_n_exchangerates("A", "EUR", 3)
      ## Preview response content
      response$content
    },
    error = function(e) message(e)
  )
}

}
\seealso{
\url{https://api.nbp.pl/#kursyWalut}

Other rates: 
\code{\link{get_current_exchangerate}()},
\code{\link{get_exchangerate_from_interval}()},
\code{\link{get_exchangerate_from}()},
\code{\link{get_todays_exchangerate}()}
}
\concept{rates}
