% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unrelated.effects.plot_function.R.R
\name{unrelated_effects_plot}
\alias{unrelated_effects_plot}
\title{End-user-ready results for unrelated trial effects model}
\usage{
unrelated_effects_plot(
  data,
  measure,
  char,
  drug_names,
  trial_names,
  mean_misspar,
  var_misspar,
  rho,
  save_xls
)
}
\arguments{
\item{data}{A data-frame of a one-trial-per-row format containing arm-level
data of each trial. See 'Format' in \code{\link{run_model}}.}

\item{measure}{Character string indicating the effect measure with values
\code{"OR"}, \code{"MD"}, \code{"SMD"}, or \code{"ROM"} for the odds ratio,
mean difference, standardised mean difference and ratio of means,
respectively.}

\item{char}{A data-frame of three columns and number of rows equal to the
number of trials in \code{data}. Each column refers to a
trial-characteristic with \strong{nominal} elements.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data}. If \code{drug_names} is
not defined, the order of the interventions as they appear in \code{data}
is used, instead.}

\item{trial_names}{A vector of labels with the name of the trials in the
order they appear in the argument \code{data}. If \code{trial_names} is not
defined, the order of the trials as they appear in \code{data} is used,
instead.}

\item{mean_misspar}{A numeric value for the mean of the normal distribution
of the informative missingness parameter (see 'Details'). The default
argument is 0 and corresponds to the missing-at-random assumption. The same
value is considered across all trials of the dataset.}

\item{var_misspar}{A positive non-zero number for the variance of the
normal distribution of the informative missingness parameter.
When the \code{measure} is \code{"OR"}, \code{"MD"}, or \code{"SMD"}
the default argument is 1. When the \code{measure} is \code{"ROM"}
the default argument is 0.04. The same value is considered across all
trials of the dataset.}

\item{rho}{A numeric value in the interval [-1, 1] that indicates the
correlation coefficient between two informative missingness parameters in
a trial. The same value is considered across all trials of the dataset.
The default argument is 0 and corresponds to uncorrelated missingness
parameters.}

\item{save_xls}{Logical to indicate whether to export the tabulated results
to an 'xlsx' file (via the \code{\link[writexl:write_xlsx]{write_xlsx}}
function of the R-package
\href{https://CRAN.R-project.org/package=writexl}{writexl}) to the working
directory of the user. The default is \code{FALSE} (do not export).}
}
\value{
A panel of interval plots for each observed comparison in the
  network, when there are up to 15 trials in the \code{data}. Otherwise,
  \code{unrelated_effects_plot} exports a data-frame to an 'xlsx' file at
  the working  directory of the user. This data-frame includes the
  \code{data} in the long format, the within-trial effect measure and
  95\% confidence interval of the corresponding comparisons, the
  interventions compared, and the three characteristics (as defined in
  \code{char}).
  For datasets with more than 15 trials, the plot becomes cluttered and it is
  difficult to identify the trial-names. Hence, exporting the results in an
  Excel file is a viable alternative.
}
\description{
Performs the unrelated trial effects model (also known as fixed
  effects model) and illustrates the results of each trial and corresponding
  pairwise comparison.
}
\details{
The unrelated trial effects model may be an alternative to network
  meta-analysis, when the latter is not deemed appropriate (e.g., there is
  considerable statistical heterogeneity, or substantial intransitivity). In
  the presence of missing participant outcome data, the effect size and
  standard error are adjusted by applying the pattern-mixture model with
  Taylor series in trial-arms with reported missing participants (Mavridis et
  al., 2015; White et al., 2008). The \code{unrelated_effects_plot} function
  calls the \code{\link{taylor_imor}} and \code{\link{taylor_continuous}}
  functions (for a binary and continuous outcome, respectively) to employ
  pattern-mixture model with Taylor series. The \code{unrelated_effects_plot}
  function considers the informative missingness odds ratio in the
  logarithmic scale for binary outcome data (White et al., 2008), the
  informative missingness difference of means when \code{measure} is
  \code{"MD"} or \code{"SMD"}, and the informative missingness ratio of means
  in the logarithmic scale when \code{measure} is \code{"ROM"}
  (Mavridis et al., 2015).

  The number of interval plots equals the number of observed comparisons in
  the network. In each interval plot, the y-axis refers to all trials of the
  network and x-axis refers to the selected effect measure. The odds ratio
  and ratio of means are calculated in the logarithmic scale but they are
  reported in their original scale after exponentiation.

  \code{unrelated_effects_plot} depicts all three characteristics for each
  trial using different colours, line-types and point-shapes for the
  corresponding 95\% confidence interval and point estimate. Ideally, each
  characteristic should have no more than three categories; otherwise, the
  plot becomes cluttered. For now, the \code{unrelated_effects_plot} function
  uses the default colour palette, line-types and point-shapes.
}
\references{
Mavridis D, White IR, Higgins JP, Cipriani A, Salanti G. Allowing for
uncertainty due to missing continuous outcome data in pairwise and network
meta-analysis. \emph{Stat Med} 2015;\bold{34}(5):721--41.
doi: 10.1002/sim.6365

White IR, Higgins JP, Wood AM. Allowing for uncertainty due to missing data
in meta-analysis--part 1: two-stage methods.
\emph{Stat Med} 2008;\bold{27}(5):711--27. doi: 10.1002/sim.3008
}
\seealso{
\code{\link{run_model}}, \code{\link{taylor_continuous}},
  \code{\link{taylor_imor}}, \code{\link[writexl:write_xlsx]{write_xlsx}}
}
\author{
{Loukia M. Spineli}
}
