% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rnoaa-package.r
\docType{package}
\name{rnoaa-package}
\alias{rnoaa}
\alias{rnoaa-package}
\title{General purpose R interface to noaa.}
\description{
rnoaa is an R interface to NOAA climate data.
}
\details{
Many functions in this package interact with the National Climatic Data Center application
programming interface (API) at \url{http://www.ncdc.noaa.gov/cdo-web/webservices/v2}, all of
which functions start with \code{ncdc_}. An access token, or API key, is required to use all
the \code{ncdc_} functions. The key is required by NOAA, not the creators of this R package.
Go to the link given above to get an API key.

More NOAA data sources are being added through time. Data sources and their function prefixes
are:

\itemize{
 \item \code{buoy_*} - NOAA Buoy data, only on buoy branch in Github repo
 \item \code{erddap_*} - NOAA ERDDAP vignette
 \item \code{ncdc_*} - NOAA National Climatic Data Center (NCDC) vignette (examples)
 \item \code{seaice} - Sea ice vignette
 \item \code{swdi} - Severe Weather Data Inventory (SWDI) vignette
 \item \code{homr_*} - Historical Observing Metadata Repository (HOMR) vignette
 \item \code{storm_} - Storms (IBTrACS) vignette
 \item \code{tornadoes} - From the NOAA Storm Prediction Center
}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
\keyword{package}

