% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isd_stations.R
\name{isd_stations}
\alias{isd_stations}
\title{Get NOAA ISD/ISH station data from NOAA FTP server.}
\usage{
isd_stations(refresh = FALSE, ...)
}
\arguments{
\item{refresh}{(logical) Download station data from NOAA ftp server again.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a tibble (data.frame) with the columns:
\itemize{
 \item usaf - USAF number, character
 \item wban - WBAN number, character
 \item station_name - station name, character
 \item ctry - Country, if given, character
 \item state - State, if given, character
 \item icao - ICAO number, if given, character
 \item lat - Latitude, if given, numeric
 \item lon - Longitude, if given, numeric
 \item elev_m - Elevation, if given, numeric
 \item begin - Begin date of data coverage, of form YYYYMMDD, numeric
 \item end - End date of data coverage, of form YYYYMMDD, numeric
}
}
\description{
Get NOAA ISD/ISH station data from NOAA FTP server.
}
\details{
The data table is cached, but you can force download of data from NOAA
by setting \code{refresh=TRUE}
}
\examples{
\dontrun{
# Get station table
(stations <- isd_stations())

## plot stations
### remove incomplete cases, those at 0,0
df <- stations[complete.cases(stations$lat, stations$lon), ]
df <- df[df$lat != 0, ]
### make plot
library("leaflet")
leaflet(data = df) \%>\%
  addTiles() \%>\%
  addCircles()
}
}
\references{
ftp://ftp.ncdc.noaa.gov/pub/data/noaa/
}
\seealso{
Other isd: \code{\link{isd_read}},
  \code{\link{isd_stations_search}}, \code{\link{isd}}
}

