% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompositionalSpline.R
\name{compositionalSpline}
\alias{compositionalSpline}
\title{Compositional spline}
\usage{
compositionalSpline(
  t,
  clrf,
  knots,
  w,
  order,
  der,
  alpha,
  spline.plot = FALSE,
  basis.plot = FALSE
)
}
\arguments{
\item{t}{class midpoints}

\item{clrf}{clr transformed values at class midpoints, i.e., fcenLR(f(t))}

\item{knots}{sequence of knots}

\item{w}{weights}

\item{order}{order of the spline (i.e., degree + 1)}

\item{der}{lth derivation}

\item{alpha}{smoothing parameter}

\item{spline.plot}{if TRUE, the resulting spline is plotted}

\item{basis.plot}{if TRUE, the ZB-spline basis system is plotted}
}
\value{
\item{\code{J}}{value of the functional J}
\item{\code{ZB_coef}}{ZB-spline basis coeffcients}
\item{\code{CV}}{score of cross-validation}
\item{\code{GCV}}{score of generalized cross-validation}
}
\description{
This code implements the compositional smoothing splines grounded on the theory of 
Bayes spaces.
}
\details{
The compositional splines enable to construct a spline basis in the centred logratio (clr) space of density 
functions (ZB-spline basis) and consequently also in the original space of densities (CB-spline basis).The resulting 
compositional splines in the clr space as well as the ZB-spline basis satisfy the zero integral constraint. 
This enables to work with compositional splines consistently in the framework of the Bayes space methodology.

Augmented knot sequence is obtained from the original knots by adding #(order-1) multiple endpoints.
}
\references{
Machalova, J., Talska, R., Hron, K. Gaba, A. Compositional splines for representation of density functions. \emph{Comput Stat} (2020). https://doi.org/10.1007/s00180-020-01042-7
}
\author{
J. Machalova \email{jitka.machalova@upol.cz}, R. Talska \email{talskarenata@seznam.cz}
}
