% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeUDLs.R
\name{imputeUDLs}
\alias{imputeUDLs}
\title{Imputation of values above an upper detection limit in compositional data}
\usage{
imputeUDLs(
  x,
  maxit = 10,
  eps = 0.1,
  method = "lm",
  dl = NULL,
  variation = TRUE,
  nPred = NULL,
  nComp = "boot",
  bruteforce = FALSE,
  noisemethod = "residuals",
  noise = FALSE,
  R = 10,
  correction = "normal",
  verbose = FALSE
)
}
\arguments{
\item{x}{data.frame or matrix}

\item{maxit}{maximum number of iterations}

\item{eps}{convergency criteria}

\item{method}{either "lm", "lmrob" or "pls"}

\item{dl}{Detection limit for each variable. zero for variables with
variables that have no detection limit problems.}

\item{variation, }{if TRUE those predictors are chosen in each step, who's variation is lowest to the predictor.}

\item{nPred, }{if determined and variation equals TRUE, it fixes the number of predictors}

\item{nComp}{if determined, it fixes the number of pls components. If
\dQuote{boot}, the number of pls components are estimated using a
bootstraped cross validation approach.}

\item{bruteforce}{sets imputed values above the detection limit to the
detection limit. Replacement above the detection limit are only exeptionally
occur due to numerical instabilities. The default is FALSE!}

\item{noisemethod}{adding noise to imputed values. Experimental}

\item{noise}{TRUE to activate noise (experimental)}

\item{R}{number of bootstrap samples for the determination of pls
components. Only important for method \dQuote{pls}.}

\item{correction}{normal or density}

\item{verbose}{additional print output during calculations.}
}
\value{
\item{x }{imputed data} \item{criteria }{change between last and
second last iteration} \item{iter }{number of iterations} \item{maxit
}{maximum number of iterations} \item{wind}{index of values above upper detection limit}
\item{nComp}{number of components for method pls} \item{method}{chosen
  method}
}
\description{
Parametric replacement of values above upper detection limit for compositional data using
classical and robust methods (possibly also the pls method) based on ilr-transformations with special
choice of balances.
}
\details{
imputeUDLs

An imputation method for right-censored compositional data. 
Statistical analysis is not possible with values reported in data, 
for example as ">10000". These values are replaced using tobit regression.

The algorithm iteratively imputes parts with values above upper detection limit
whereas in each step (1) compositional data are expressed in pivot coordinates (2) tobit regression is
applied (3) the values above upper detection limit are replaced by the expected values (4) the
corresponding inverse ilr mapping is applied. After all parts are
imputed, the algorithm starts again until the imputations only change marginally.
}
\examples{
data(gemas)  # read data
dat <- gemas[gemas$COUNTRY=="HEL",c(12:29)]
UDL <- apply(dat,2,max)
names(UDL) <- names(dat)
UDL["Mn"] <- quantile(dat[,"Mn"], probs = 0.8)  # UDL present only in one variable
whichudl <- dat[,"Mn"] > UDL["Mn"] 
# classical method
imp.lm <- dat
imp.lm[whichudl,"Mn"] <- Inf
res.lm <- imputeUDLs(imp.lm, dl=UDL, method="lm", variation=TRUE)
imp.lm <- res.lm$x


}
\references{
Martin-Fernandez, J.A.,  Hron K.,  Templ, M., Filzmoser, P.  and Palarea-Albaladejo, J. (2012).
Model-based replacement of rounded zeros in compositional data:  Classical and robust approaches.
\emph{Computational Statistics and Data Analysis}, 56, 2688-2704.

Templ, M. and Hron, K. and Filzmoser and Gardlo, A. (2016). 
Imputation of rounded zeros for high-dimensional compositional data. 
\emph{Chemometrics and Intelligent Laboratory Systems}, 155, 183-190.
}
\seealso{
\code{\link{imputeBDLs}}
}
\author{
Peter Filzmoser, Dominika Miksova based on function imputeBDLs code from Matthias Templ
}
\keyword{manip}
\keyword{multivariate}
