% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SigmaFunctions.R
\name{find_eta}
\alias{find_eta}
\title{The proportionality constant \eqn{\eta} of the t-MLE for scatter}
\usage{
find_eta(df_data, df_est, p)
}
\arguments{
\item{df_data}{A positive real number or \code{Inf}. The degrees of freedom of the
data-generationg t-distribution. \code{Inf} means normal distribution.}

\item{df_est}{A positive real number or \code{Inf}. The degrees of freedom of the
t-distribution the M-estimator is derived from. \code{Inf} is the usual sample covariance
(i.e. the MLE under normality).}

\item{p}{An integer, at least 2.}
}
\value{
A real value. Returns the constant \eqn{\eta} (cf. Vogel and Tyler 2014, p. 870, Example 2).
   This first appeared in Tyler (1982, p. 432, Example 3) as \eqn{\sigma^{-1}}.
   It is also stated in Tyler (1983, p. 418) as \eqn{\sigma^{-1}_{u,g}}.
}
\description{
The proportionality constant \eqn{\eta} of the t-MLE for scatter
}
\details{
Let \eqn{X_1,...,X_n} be an i.i.d.\ sample from \eqn{t_{\nu,p}(\mu, S)}, i.e.,
a p-variate t-distribution with \eqn{\nu} degrees of freedom, location parameter \eqn{\mu}
and shape matrix \eqn{S}. The limit case \eqn{\nu=\infty} is allowed, where \eqn{t_{\infty,p}(\mu,S)} is
\eqn{N_p(\mu,S)}.
\cr

Let \eqn{\hat{S}_n} be the \eqn{t_m} MLE for scatter. Also here, \eqn{m=\infty} is allowed:
This is the sample covariance matrix.
If \eqn{\hat{S}_n} is applied to \eqn{X_1,...,X_n}, then, as \eqn{n \to \infty},
\eqn{\hat{S}_n} converges in probability to \eqn{\eta S}.
The function \code{find_eta()} returns the proportionality constant \eqn{\eta}
for inputs \eqn{\nu, m} and \eqn{p}.
(Note: if \eqn{\nu \neq m}, \eqn{\hat{S}_n} is technically not an MLE, but an M-estimator.)
\cr
\cr
Some specific values:
\itemize{
\item
  If \eqn{\nu = m} (also for \eqn{\infty = \infty}), then \eqn{\eta = 1}
  (i.e., the MLE at the corresponding population
  distribution consistently estimates its population value).
\item
  If \eqn{m = \infty} and \eqn{2 < \nu < \infty}, then \eqn{\eta = \nu/(\nu-2)}.
\item
  If \eqn{m = \infty} and \eqn{\nu <= 2}, then \eqn{\eta = \infty}.
  Precisely: \eqn{\hat{S}_n} does not
  converge in this case.
}

The general expressions: \eqn{\eta} is the solution to
\cr
\eqn{F(\eta) = E(\phi(R/\eta)) - p = 0},
\cr
where \eqn{\phi(y) = y(m+p)/(m+y)} and \eqn{R = (X - \mu)^\top S^{-1} (X-\mu)} for
\eqn{X \sim t_{\nu,p}(\mu,S)}.
For the integral, \code{stats::integrate} is used, for finding the root the
function \code{stats::uniroot}.

In general, \eqn{\nu} (\code{df_data}) and \eqn{m} (\code{df_est}) can take on any
positive value, including \eqn{\infty}. The function works well for \eqn{p <= 100} and
\eqn{\nu >= 1}. For larger values of \eqn{p}, setting \eqn{\eta = 1} provides a good approximation
(unless df_data is very small and df_est is rather large).
For smaller values of \eqn{\nu}, try the following potential remedies:
\itemize{
\item Re-consider if \eqn{\nu < 1} is really necessary. This is VERY heavy-tailed.
\item Adaptation of the search interval.
\item By a suitable substitution, transform the integral to numerically more stable one (bounded support).
}

\eqn{F(\eta)} is a decreasing function.
\itemize{
\item The larger df_est, the larger \eqn{\eta}.
\item The larger df_data, the smaller \eqn{\eta}.
\item The larger \eqn{p}, the closer \eqn{\eta} is to 1. }
}
\examples{
find_eta(df_data = Inf, df_est = 3,   p = 10)
find_eta(df_data = 4.5, df_est = 4.5, p = 2)
}
\references{
Tyler, D. E. (1982): Radial estimates and the test for sphericity,
  \emph{Biometrika}, 69, 2, pp. 429-36
  \cr\cr
  Tyler, D. E. (1983): Robustness and efficiency properties of scatter matrices,
  \emph{Biometrika}, 70, 2, pp. 411-20
  \cr\cr
  Vogel, D., Tyler, D. E. (2014): Robust estimators
  for nondecomposable elliptical graphical models, \emph{Biometrika}, 101, 865-882
}
\author{
Daniel Vogel
}
