% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot-methods}
\alias{plot-methods}
\alias{autoplot.fit_mediation}
\alias{autoplot.test_mediation}
\alias{plot.fit_mediation}
\alias{plot.test_mediation}
\title{Plot (robust) mediation analysis results}
\usage{
\method{autoplot}{fit_mediation}(object, which = c("ellipse", "weight"), ...)

\method{autoplot}{test_mediation}(object, which = c("ci", "density", "ellipse", "weight"), ...)

\method{plot}{fit_mediation}(x, which = c("ellipse", "weight"), ...)

\method{plot}{test_mediation}(x, which = c("ci", "density", "ellipse", "weight"), ...)
}
\arguments{
\item{object, x}{an object inheriting from class
\code{"\link{fit_mediation}"} or \code{"\link{test_mediation}"} containing
results from (robust) mediation analysis.}

\item{which}{a character string specifying which plot to produce.
Possible values are \code{"ci"} for a dot plot of selected effects
together with confidence intervals (see \code{\link{ci_plot}()}),
\code{"density"} for a density plot of the indirect effect(s) (see
\code{\link{density_plot}()}), \code{"ellipse"} for a diagnostic plot
of the data together with a tolerance ellipse (see
\code{\link{ellipse_plot}()}), and \code{"weight"} for a diagnostic plot
of robust regression weights (see \code{\link{weight_plot}()}).}

\item{\dots}{additional arguments to be passed down.}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}.
}
\description{
Visualize results from (robust) mediation analysis.
}
\details{
The \code{"\link{fit_mediation}"} method calls \code{\link{ellipse_plot}()}
or \code{\link{weight_plot}()}, depending on the argument \code{which}.

The \code{"\link{test_mediation}"} method calls \code{\link{ci_plot}()},
\code{\link{density_plot}()}, \code{\link{ellipse_plot}()}, or
\code{\link{weight_plot}()}, depending on the argument \code{which}.
}
\examples{
data("BSG2014")

# run fast-and-robust bootstrap test
test <- test_mediation(BSG2014,
                       x = "ValueDiversity",
                       y = "TeamCommitment",
                       m = "TaskConflict")

# create plots for robust bootstrap test
plot(test, which = "ci")
plot(test, which = "density")
plot(test, which = "ellipse")
plot(test, which = "weight")

}
\seealso{
\code{\link{fit_mediation}()}, \code{\link{test_mediation}()}

\code{\link{ci_plot}()}, \code{\link{density_plot}()},
\code{\link{ellipse_plot}()}, \code{\link{weight_plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
