% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_value.R
\name{p_value}
\alias{p_value}
\alias{p_value.boot_test_mediation}
\alias{p_value.sobel_test_mediation}
\title{p-Values for (robust) mediation analysis}
\usage{
p_value(object, ...)

\method{p_value}{boot_test_mediation}(object, digits = 4L, ...)

\method{p_value}{sobel_test_mediation}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class
\code{"\link{test_mediation}"} containing results
from (robust) mediation analysis.}

\item{\dots}{additional arguments are currently ignored.}

\item{digits}{an integer determining the number of digits of the p-values
to be computed.  The default is to compute 4 digits after the comma.}
}
\value{
A numeric vector containing the p-values for the indirect
effect(s).
}
\description{
Estimate or extract the p-values for indirect effects in (robust) mediation
analysis.
}
\details{
For bootstrap tests, the p-value is estimated as the smallest significance
level \eqn{\alpha}{alpha} for which the
\eqn{(1 - \alpha) * 100\%}{(1 - alpha) * 100\%} confidence interval obtained
from the bootstrapped distribution of the indirect effect does not contain
0.

This is a simple implementation, where each digit after the comma is
determined via a grid search.  Hence computation time can be long if
confidence intervals are computed via the bias-corrected and accelerated
method (\code{"bca"}).

For Sobel tests, the p-value is already stored in the object returned by
\code{\link{test_mediation}()} and simply extracted.
}
\examples{
data("BSG2014")

\donttest{
# BCa intervals are recommended, but take a while to run
test_bca <- test_mediation(BSG2014,
                           x = "ValueDiversity",
                           y = "TeamCommitment",
                           m = "TaskConflict",
                           type = "bca")
p_value(test_bca)
}

}
\seealso{
\code{\link{test_mediation}()}, \code{\link[boot]{boot.ci}()}
}
\author{
Andreas Alfons
}
\keyword{utilities}
