% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robservable.R
\name{robservable}
\alias{robservable}
\title{Display an Observable notebook as HTML widget}
\usage{
robservable(
  notebook,
  include = NULL,
  hide = NULL,
  input = NULL,
  observers = NULL,
  update_height = TRUE,
  update_width = TRUE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{notebook}{The notebook id, such as "@d3/bar-chart", or the full notebook URL.}

\item{include}{character vector of cell names to be rendered. If NULL,  the whole notebook is rendered.}

\item{hide}{character vector of cell names in \code{include} to be hidden in the output.}

\item{input}{A named list of cells to be updated.}

\item{observers}{A vector of character strings representing variables in observable that
you would like to set as input values in Shiny.}

\item{update_height}{if TRUE (default) and input$height is not defined, replace its value with the height of the widget root HTML element. Note there will not always be such a cell in every notebook. Set it to FALSE to always keep the notebook value.}

\item{update_width}{if TRUE (default) and input$width is not defined, replace its value with the width of the widget root HTML element. Set it to FALSE to always keep the notebook or the Observable stdlib value.}

\item{width}{htmlwidget width.}

\item{height}{htmlwidget height.}

\item{elementId}{optional manual widget HTML id.}
}
\value{
An object of class \code{htmlwidget}.
}
\description{
Display an Observable notebook as HTML widget
}
\details{
If a data.frame is passed as a cell value in \code{input}, it will be converted into the format
expected by \code{d3} (ie, converted by rows)..
}
\examples{
## Display a notebook cell
robservable(
  "@d3/bar-chart",
  include = "chart"
)

## Change cells data with input
robservable(
  "@d3/bar-chart",
  include = "chart",
  input = list(color = "red", height = 700)
)

## Change data frame cells data
df <- data.frame(table(mtcars$cyl))
names(df) <- c("name", "value")
robservable(
  "@d3/horizontal-bar-chart",
  include = "chart",
  input = list(data = df)
)

}
