% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_inf_test.R
\name{beta_hausman}
\alias{beta_hausman}
\title{Calculates a Hausman test on the difference between robust and full sample
estimates}
\usage{
beta_hausman(robust2sls_object, iteration, subset = NULL, fp = FALSE)
}
\arguments{
\item{robust2sls_object}{An object of class \code{"robust2sls"}.}

\item{iteration}{An integer > 0 specifying the iteration step for which
parameters to calculate corrected standard errors.}

\item{subset}{A vector of numeric indices or strings indicating which
coefficients to include in the Hausman test. \code{NULL} uses the whole
vector of coefficients.}

\item{fp}{A logical value whether the fixed point asymptotic variance
(TRUE) or the exact iteration asymptotic variance should be used (FALSE).}
}
\value{
\code{beta_hausman} returns a matrix with the value of the Hausman
test statistic and its corresponding p-value. The attribute
\code{"type of avar"} records which asymptotic variance has been used (the
specific iteration or the fixed point). The attribute \code{"coefficients"}
stores the names of the coefficients that were included in the Hausman test.
}
\description{
Calculates a Hausman test on the difference between robust and full sample
estimates
}
\details{
Argument \code{fp} determines whether the fixed point asymptotic variance
should be used. This argument is only respected if the specified
\code{iteration} is one of the iterations after the algorithm converged.
}
