% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test.R
\name{t_test_one_sample}
\alias{t_test_one_sample}
\title{Generate one-sample t-test results for multiple sub-groups}
\usage{
t_test_one_sample(data, x, mu = 0, p_adjust = "bonferroni")
}
\arguments{
\item{data}{A grouped data frame. It should be grouped by the intended sub-groups which you want to do the
same t-test.}

\item{x}{Column name of the variable which contains data values that you want to test (see \link[stats]{t.test} and details).}

\item{mu}{A number indicating the true value of the mean (or difference in means
if you are performing a two sample test).}

\item{p_adjust}{\code{character} indicating which method should be used for
adjusting multiple comparisons (see \link[stats]{p.adjust} and details).
The default \code{"bonferroni"} corresponds to Bonferroni adjustment.}
}
\value{
A \code{data.frame} with the t-statistics table
consisting of characters. The columns that are always present are:
\code{group variable(s)}, \code{tvalue}, \code{df} (degrees of freedom), \code{p}, and \code{p_adjustmethod(s)}.
}
\description{
This function produce one-sample t-test (two-tailed with confident interval at 0.95) results for multiple sub-groups and provides with
a nice output in a table format. It can also add adjusted p values for multiple comparison
issue.
}
\examples{
t_test_one_sample(color_index, "color_index", mu = 0)

# use bonferroni and fdr method for adjusted p values.
library(magrittr)
color_index \%>\%
  t_test_one_sample("color_index", mu = 0, p_adjust = c("bonferroni","fdr"))
}
