% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollinglda-package.R
\docType{package}
\name{rollinglda-package}
\alias{rollinglda}
\alias{rollinglda-package}
\title{rollinglda: Construct Consistent Time Series from Textual Data}
\description{
RollingLDA is a rolling version of the Latent Dirichlet
Allocation (LDA). By a sequential approach, it enables the construction of
LDA-based time series of topics that are consistent with previous states of
LDA models. After an initial modeling, updates can be computed efficiently,
allowing for real-time monitoring and detection of events or structural breaks.\cr
For bug reports and feature requests please use the issue tracker:
\url{https://github.com/JonasRieger/rollinglda/issues}. Also have a look at
the (detailed) example at \url{https://github.com/JonasRieger/rollinglda}.
}
\section{Data}{

\code{\link{economy}} Example Dataset (576 articles from Wikinews) for testing.
}

\section{Constructor}{

\code{\link{as.RollingLDA}} RollingLDA objects used in this package.
}

\section{Getter}{

\code{\link{getChunks}} Getter for \code{\link[=as.RollingLDA]{RollingLDA}} objects.
}

\section{Modeling}{

\code{\link{RollingLDA}} Performing the method from scratch.\cr
\code{\link{updateRollingLDA}} Performing updates on \code{\link[=as.RollingLDA]{RollingLDA}} objects.
}

\references{
Rieger, Jonas, Carsten Jentsch and Jörg Rahnenführer (2021).
"RollingLDA: An Update Algorithm of Latent Dirichlet Allocation to Construct
Consistent Time Series from Textual Data". Accepted for \emph{Findings of EMNLP 2021}.
URL \url{https://www.statistik.tu-dortmund.de/fileadmin/user_upload/Lehrstuehle/IWuS/Forschung/rollinglda.pdf}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/JonasRieger/rollinglda}
  \item Report bugs at \url{https://github.com/JonasRieger/rollinglda/issues}
}

}
\author{
\strong{Maintainer}: Jonas Rieger \email{jonas.rieger@tu-dortmund.de} (\href{https://orcid.org/0000-0002-0007-4478}{ORCID})

}
