% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa.R
\name{maxwell.kappa}
\alias{maxwell.kappa}
\title{Circular variance and concentration parameter}
\usage{
maxwell.kappa(nu)
}
\arguments{
\item{nu}{circular variance}
}
\value{
Concentration parameter corresponding to nu.
}
\description{
Return the concentration parameter that corresponds to a given circular
variance.
}
\details{
The concentration parameter \eqn{\kappa} does not translate across circular
distributions.  A commonly used measure of spread in circular distributions
that does translate is the circular variance defined as
\eqn{\nu=1-E[\cos(r)]}{\nu=1-E[cos(r)]} where \eqn{E[\cos(r)]}{E[cos(r)]} is
the mean resultant length.  See \cite{mardia2000} for more details. This
function translates the circular variance \eqn{\nu} into the corresponding
concentration parameter \eqn{\kappa} for the modified Maxwell-Boltzmann
distribution.  For numerical stability, a maximum \eqn{\kappa} of 1000 is
returned.
}
\examples{
# Find the concentration parameter for circular variances 0.25, 0.5, 0.75
maxwell.kappa(0.25)
maxwell.kappa(0.5)
maxwell.kappa(0.75)
}
\seealso{
\code{\link{Maxwell}}
}
