% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizelimit_route.R
\name{sizelimit_route}
\alias{sizelimit_route}
\title{Limit the size of requests}
\usage{
sizelimit_route(limit = 5 * 1024^2)
}
\arguments{
\item{limit}{Either a numeric or a function returning a numeric when called
with the request}
}
\value{
\code{TRUE} if the request are allowed to proceed, or \code{FALSE} if it should
be terminated
}
\description{
This route is meant for being called prior to retrieving of the request body.
It inspects the \code{Content-Length} header and determines if the request should
be allowed to proceed. The limit can be made variable by supplying a function
to the \code{limit} argument returning a numeric. If the \code{Content-Length} header
is missing and the limit is not \code{Inf} the response will be set to
\code{411 - Length Required}, If the header exists but exceeds the limit the
response will be set to \code{413 - Request Entity Too Large}. Otherwise the route
will return \code{TRUE} and leave the response unchanged.
}
\examples{
limit_route <- sizelimit_route() # Default 5Mb limit
rook <- fiery::fake_request('http://www.example.com', 'post',
                            headers = list(Content_Length = 30*1024^2))
req <- reqres::Request$new(rook)
limit_route$dispatch(req)
req$respond()

}
\seealso{
Other Route constructors: \code{\link{ressource_route}}
}
