\name{phyloP.sph}
\alias{phyloP.sph}
\title{phyloP SPH}
\usage{phyloP.sph(mod, msa=NULL, mode="CON", features=NULL, basewise=FALSE,
    subtree=NULL, ref.idx=1, outfile=NULL, outfile.only=FALSE,
    outfile.format="default", prior.only=FALSE, nsites=NULL,
    post.only=FALSE, fit.model=FALSE, epsilon=ifelse(basewise, 1e-06,
    1e-10), confidence.interval=NULL, quantiles=FALSE)}
\description{phyloP in SPH mode}
\value{Either a list, data frame, or matrix, depending on options.}
\author{Melissa J. Hubisz and Adam Siepel}
\arguments{\item{mod}{An object of class \code{tm} representing the neutral model.}
\item{msa}{The multiple alignment to be scored.}
\item{mode}{The type of p-value to compute.  One of "CON", "ACC",
"NNEUT", or "CONACC".}
\item{features}{A features object of type \code{feat}.  If given, compute
p-values for each element.}
\item{basewise}{Logical.  If \code{TRUE}, compute scores for every base
in reference sequence.  Cannot be \code{TRUE} if features is provided.}
\item{subtree}{A character string giving the name of a node in the tree.
Partition the tree into the subtree beneath the node and the
complementary supertree, and consider conservation/acceleration in the
subtree given the supertree.  The branch above the specified node is
included with the subtree.}
\item{ref.idx}{index of reference sequence in the alignment.  If zero,
use frame of reference of entire alignment.}
\item{outfile}{Character string.  If given, write results to given file.}
\item{outfile.only}{Logical.  If \code{TRUE}, do not return any
results to R (this may be useful for saving memory).}
\item{outfile.format}{Character string describing output format.  Possible
formats depend on other options (see description below).}
\item{prior.only}{Logical.  If \code{TRUE}, compute only prior
distribution of number of substitutions over nsites sites.  Alignment
is ignored in this case.}
\item{nsites}{Integer.  Number of sites to consider if prior.only is
\code{TRUE}.}
\item{post.only}{Logical.  If \code{TRUE}, compute the posterior
distribution of the number of substitutions given the the neutral model
and the alignment.}
\item{fit.model}{Logical.  If \code{TRUE}, re-scale the model (including
a separate scale for the subtree, if applicable) before computing the
posterior distribution.   This makes p-values less conservative.
Cannot currently be used with features.}
\item{epsilon}{Numeric value indicating the thhreshold used in truncating
tails of distributions; tail probabilities less than this value are
discarded.  This only applies to the right tail.}
\item{confidence.interval}{Numeric value between 0 and 1.  If given,
allow for uncertainty in the estimate of the actual number of substitutions
by using a central confidence interval about the mean of given size.
To be conservative, the maximum of this interval is used when computing
a p-value of conservation, and the minimum is used when computing
a p-value of acceleration.  The variance of the posterior is computed
exactly, but the confidence interval is based on the assumption that
the combined distribution will be approximately normal (true for
large numbers of sites by the central limit theorem).}
\item{quantiles}{Logical.  If \code{TRUE}, report quantiles of distribution
rather than whole distribution.}}
