% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_plum.R
\name{draw.pbmodelled}
\alias{draw.pbmodelled}
\title{Plot the 210Pb data}
\usage{
draw.pbmodelled(
  set = get("info"),
  BCAD = set$BCAD,
  rotate.axes = FALSE,
  rev.d = FALSE,
  rev.age = FALSE,
  pb.lim = c(),
  d.lim = c(),
  d.lab = c(),
  pb.lab = c(),
  pbmodelled.col = function(x) rgb(0, 0, 1, x),
  pbmeasured.col = "blue",
  supp.col = "red",
  plot.measured = TRUE,
  age.lim = c()
)
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{BCAD}{The calendar scale of graphs is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{rotate.axes}{The default of plotting age on the horizontal axis and event probability on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{rev.d}{The direction of the depth axis can be reversed from the default (\code{rev.d=TRUE}).}

\item{rev.age}{The direction of the calendar age axis can be reversed from the default (\code{rev.age=TRUE})}

\item{pb.lim}{Minimum and maximum of the 210Pb axis ranges, calculated automatically by default (\code{pb.lim=c()}).}

\item{d.lim}{Minimum and maximum depths to plot; calculated automatically by default (\code{d.lim=c()}).}

\item{d.lab}{The labels for the depth axis. Default \code{d.lab="Depth (cm)"}.}

\item{pb.lab}{The label for the 210Pb axis (default \code{pb.lab="210Pb (Bq/kg)"} or \code{"210Pb (dpm/g)"}).}

\item{pbmodelled.col}{Colour of the modelled 210Pb data. Defaults to shades of blue: \code{pbmodelled.col=function(x) rgb(0,0,1,x)}.}

\item{pbmeasured.col}{Colour of the measured 210Pb data. Defaults to blue: \code{pbmeasured.col="blue"}.}

\item{supp.col}{Colour of the supported 210Pb data. Defaults to red: \code{supp.col="red"}.}

\item{plot.measured}{Plot the measured 210Pb values (default \code{plot.measured=TRUE}).}

\item{age.lim}{values of the age axis. Used to calculate where to plot the pb values on the secondary axis}
}
\value{
A plot of the modelled (and optionally the measured) 210Pb values
}
\description{
Produce a plot of the 210Pb data and their depths
}
\details{
This function is generally called internally to produce the age-depth graph.
It can be used to produce custom-built graphs.
}
\author{
Maarten Blaauw, J. Andres Christen, Marco Aquino-Lopez
}
