% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.rpm.R
\name{control.rpm}
\alias{control.rpm}
\title{Auxiliary for Controlling rpm}
\usage{
control.rpm(
  init_theta = NULL,
  algorithm = "NLOPT_LD_SLSQP",
  print_level = 0,
  xtol_rel = 1e-08,
  ftol_rel = 1e-08,
  ftol_abs = 1e-06,
  lower.bound = -10,
  upper.bound = 10,
  maxeval = 2000,
  bs.maxeval = 2000,
  bs.xtol_rel = 1e-08,
  check_derivatives = FALSE,
  bootstrap = TRUE,
  hessian = FALSE,
  seed = NULL,
  parallel.type = "PSOCK",
  parallel.ncores = 1,
  ncores = 1,
  constraints = c("none", "M_single"),
  logodds_single = FALSE,
  save.data = TRUE,
  robust.cov = FALSE,
  local_opts = list(algorithm = "NLOPT_LD_SLSQP", xtol_rel = 1e-07, maxeval = maxeval),
  nbootstrap = 50,
  nbootstrap.SD = 20,
  large.population.bootstrap = 5000,
  alpha = 0.05
)
}
\arguments{
\item{init_theta}{vector; numeric vector of starting parameter values. This value and other possible 
starting values are applied to find a good optimizer. This can either have length the number of parameters
corresponding to the terms in the formula or in addition the equilibrium constraints.}

\item{algorithm}{string; The optimization algorithm to use. See \code{nloptr::nloptr.print.options()}
and the \code{NLopt} website for a description of the algorithms.}

\item{print_level}{integer; possible values: 0, 1, 2, or 3.
This controls how much output is shown during the
optimization process. Possible values: 0 (default): no output; 1:
show iteration number and value of objective function; 2: 1 + show
value of equalities/constraints; 3: 2 + show value of controls.}

\item{xtol_rel}{scalar; Stop when an optimization step (or an estimate of the optimum)
changes every parameter by less than xtol_rel multiplied by the
absolute value of the parameter. If there is any chance that an
optimal parameter is close to zero, you might want to set an absolute
tolerance with xtol_abs as well. Criterion is disabled if xtol_rel is
non-positive. Possible values: xtol_rel > 0. Default value: 1.0e-08.}

\item{ftol_rel}{scalar; Stop when an optimization step (or an estimate of the optimum)
changes the log-likelihood by less than ftol_rel multiplied by the
absolute value of the log-likelihood.}

\item{ftol_abs}{scalar; Stop when an optimization step (or an estimate of the optimum)
changes the log-likelihood by less than ftol_abs.
tolerance with xtol_abs as well. Criterion is disabled if ftol_abs is
non-positive. Possible values: ftol_abs > 0. Default value: 1.0e-06.}

\item{lower.bound}{numeric; lower bounds on the parameter estimates (that is, the beta 
and gamma parameters in the model). Can be a vector of the same size as the coefficient
vector or a single number which is used for all bounds.}

\item{upper.bound}{numeric; upper bounds on the parameter estimates (that is, the beta 
and gamma parameters in the model). Can be a vector of the same size as the coefficient
vector or a single number which is used for all bounds.}

\item{maxeval}{integer; Stop when the number of function evaluations exceeds maxeval. This is
not a strict maximum: the number of function evaluations may exceed
maxeval slightly, depending upon the algorithm. Criterion is disabled
if maxeval is non-positive. Default value: 1000.}

\item{bs.maxeval}{integer; Stop the bootstrap optimization when the number of function evaluations exceeds bs.maxeval. This is
not a strict maximum: the number of function evaluations may exceed
bs.maxeval slightly, depending upon the algorithm. Criterion is disabled
if bs.maxeval is non-positive. Default value:50}

\item{bs.xtol_rel}{scalar; Stop the bootstrap optimization when an optimization step (or an estimate of the optimum)
changes every parameter by less than bs.xtol_rel multiplied by the
absolute value of the parameter. See the parameter xtol_rel for details.}

\item{check_derivatives}{logical; Compare the user-supplied analytic gradients
with the finite difference approximations.}

\item{bootstrap}{logical; If  `TRUE` use a bootstrap to compute the standard errors and associated
covariance matrices. If `FALSE` base the standard errors and associated
covariance matrices on the Hessian of the
(constrained) log-likelihood. 
In all cases the extended covariance matrix is returned in \code{ext.covar.hessian}.
This is the matrix of parameters, log-odds of being single and the Lagrange multipliers.}

\item{hessian}{logical; Depreciated. The negation of the `bootstrap` argument.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[base]{set.seed}}}

\item{parallel.type}{The type of cluster to run. The typical choices are "MPI" and "PSOCK", where you
must have "MPI" installed to use the former. The default
is "PSOCK".}

\item{parallel.ncores}{count; Depreciated. The renamed `ncores` argument.}

\item{ncores}{Number of processors to use in the bootstrap computations. The default
is 1, that is no parallel processing.}

\item{constraints}{string; Additional constraints to force the proportions of singles to
match the (weighted) population estimates? This should not be required, but does stabilize
the estimates in cases where there is much uncertainty.
The possible values are "none" and "M_single" (the numbers of male singles of 
each type are reproduced). Note that adding constraints leads to 
over-constrained optimization which may fail.}

\item{logodds_single}{logical; Should the log-odds ratio of being single relative to a randomly chosen person of the same sex from the 
the population be returned. If FALSE the log-odds of being single relative is returned. This is a pure preference parameter.}

\item{save.data}{logical; Should the data be saved in the return list (as components
\code{Xdata} and \code{Zdata}).}

\item{robust.cov}{logical; Should the covariance matrix of the estimates be computed using a
robust method (MASS::cov.mcd)? Only use if the bootstrap is unstable.}

\item{local_opts}{list; list of options for \code{nloptr} sub-algorithm. See the \code{nloptr} package, but these are rarely changed.}

\item{nbootstrap}{integer; Number of bootstrap resamples to take in the estimation of the
covariance matrix of the parameter estimates.}

\item{nbootstrap.SD}{integer; Number of bootstrap resamples to take in the estimation of the
variances used in the studentized bootstrap. This is run for each nbootstrap sample and so is expensive.}

\item{large.population.bootstrap}{integer; If the population size exceeds \code{large.population.bootstrap} then 
the large population approximation is used to simulate the matchings in the bootstrap. Otherwise the 
small population simulation is used (including the Gale-Shapley algorithm).
The small population method is more accurate in smaller populations, with the default cutoff being 5000 people.}

\item{alpha}{proportion; Type I error rate for the confidence intervals produced by the bootstrap.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning RPM model fitting algorithm,
which computes the MLPLE of the Revealed Preferences Model via optimization.
}
\details{
This function is only used within a call to the \code{\link{rpm}}
function.

 Some of the arguments are not yet fully implemented.
It will evolve slower to incorporate more
arguments as the package develops.
}
\seealso{
\code{\link{rpm}}
}
\keyword{models}
