% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.rpm.R
\name{logLik.rpm}
\alias{logLik.rpm}
\title{A \code{\link{logLik}} method for [`rpm`] fits.}
\usage{
\method{logLik}{rpm}(object, ...)
}
\arguments{
\item{object}{An \code{\link[=rpm.object]{rpm}} fit, returned by
\code{\link{rpm}}.}

\item{\dots}{Other arguments to the likelihood functions.}
}
\value{
a \code{\link{logLik}} object.
}
\description{
A function to return the log-likelihood associated with an
\code{\link[=rpm.object]{rpm}} fit
}
\examples{
library(rpm)
data(fauxmatching)
\donttest{
fit <- rpm(~match("edu") + WtoM_diff("edu",3),
          Xdata=fauxmatching$Xdata, Zdata=fauxmatching$Zdata,
          X_w="X_w", Z_w="Z_w",
          pair_w="pair_w", pair_id="pair_id", Xid="pid", Zid="pid",
          sampled="sampled",sampling_design="stock-flow")
logLik(fit)
}

}
\seealso{
\code{\link{logLik}}, \code{\link{logLikNull}}
}
\keyword{models}
