% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbUtils_notExported.R
\name{dbTableNameFix}
\alias{dbTableNameFix}
\title{Format input for database schema/table names.}
\usage{
dbTableNameFix(conn = NULL, t.nm, as.identifier = TRUE)
}
\arguments{
\item{conn}{A connection object. Must be provided but can be set NULL,
where a dummy connection will be used.}

\item{t.nm}{Table name string, length 1-2.}

\item{as.identifier}{Boolean whether to return (schema,table) name as database
sanitized identifers (TRUE) or as regular character (FALSE)}
}
\value{
character vector of length 2. Each character element is in
    (escaped) double-quotes when as.identifier = TRUE.
}
\description{
Internal rpostgis function to return common (length = 2) schema
and table name vector from various table and schema + table name
inputs.
}
\examples{
\dontrun{
name<-c("schema","table")
dbTableNameFix(conn,name)

#current search path schema is added to single-length character object (if only table is given)
name<-"table"
dbTableNameFix(conn,name)

#schema or table names with double quotes should be given exactly as they are 
(make sure to wrap in single quotes in R):
name<-c('sch"ema','"table"')
dbTableNameFix(conn,name)
}
}
\keyword{internal}

