% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltraj2pgtraj.R
\name{ltraj2pgtraj}
\alias{ltraj2pgtraj}
\title{Export ltraj object from R to a PostGIS database.}
\usage{
ltraj2pgtraj(conn, ltraj, schema = "traj", pgtraj = NULL, note = NULL,
  overwrite = FALSE, infolocs = TRUE)
}
\arguments{
\item{conn}{A connection object.}

\item{ltraj}{An object of class \code{ltraj}.}

\item{schema}{Character. Name of the schema that stores or will
store the pgtraj data model.}

\item{pgtraj}{Character. Name of the new \code{pgtraj}. Defaults
to the name of the provided \code{ltraj}.}

\item{note}{Character. A note that will be stored with the
\code{pgtraj} in the database.}

\item{overwrite}{Logical. Use if a \code{pgtraj} with the same
name as the provided \code{ltraj} already exists in the
database: If \code{TRUE}, the existing \code{pgtraj} is
deleted and the provided \code{ltraj} is inserted. If
\code{FALSE}, the function exits. Note that \code{overwrite}
requires an exact match among the \code{pgtraj} names
otherwise it is ignored.}

\item{infolocs}{Logical. Whether to write infolocs to database.}
}
\value{
\code{TRUE} on success.
}
\description{
\code{ltraj2pgtraj} exports an ltraj to the a database pgtraj,
creating a new pgtraj schema if it doesn't exist. The time zone and
projection information stored in the ltraj is transferred to the
database.
}
\examples{
\dontrun{
  # create pgtraj from ltraj "ibex" in schema "traj_t2"
  ltraj2pgtraj(conn, ibex, "traj_t2")
}
}
\author{
Balázs Dukai \email{balazs.dukai@gmail.com}
}
\seealso{
\code{\link{as_pgtraj}} to create a \code{pgtraj} with
    data already stored in the database.
}

