% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ex_data_frame.R
\name{execute_data_frame}
\alias{execute_data_frame}
\title{Attempt to execute a pipeline (assuming it has local data, or is passed local data).}
\usage{
execute_data_frame(optree, ..., env = parent.frame(), data = NULL,
  result_limit = NULL)
}
\arguments{
\item{optree}{rquery relop pipeline.}

\item{...}{force later arguments to bind by name.}

\item{env}{environment to work in.}

\item{data}{data.frame to evaluate.}

\item{result_limit}{numeric if not null limit result to this many rows.}
}
\value{
executed pipleline or NULL if not executable.
}
\description{
Attempt to execute a pipeline (assuming it has local data, or is passed local data).
}
\examples{

winvector_temp_db_handle <- list(
  db = DBI::dbConnect(RSQLite::SQLite(), ":memory:")
)
RSQLite::initExtension(winvector_temp_db_handle$db)

d <- data.frame(AUC = 0.6, R2 = c(0.1, 0.2), D = NA, z = 2)
optree <- table_source("d", c("AUC", "R2", "D")) \%.>\%
	extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(.,  rev_cols = "R2")

rquery_apply_to_data_frame(d, optree)

execute_data_frame(optree, data = d)

d \%.>\% optree
# run (and build result for) ad-hoc query
d \%.>\%
  extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(., rev_cols = "R2") \%.>\%
  execute_data_frame(.)
# print ad-hoc query (result only available for printing)
d \%.>\%
  extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(., rev_cols = "R2")

DBI::dbDisconnect(winvector_temp_db_handle$db)
winvector_temp_db_handle <- NULL

}
