% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_controller.R
\name{describe_tables}
\alias{describe_tables}
\title{Build a nice description of a table.}
\usage{
describe_tables(db, tablenames, ..., keyInspector = key_inspector_all_cols)
}
\arguments{
\item{db}{database handle}

\item{tablenames}{character, names of tables to describe.}

\item{...}{force later arguments to bind by name.}

\item{keyInspector}{function that determines prefered primary key set for tables.}
}
\value{
table describing the data.
}
\description{
Please see \url{http://www.win-vector.com/blog/2017/05/managing-spark-data-handles-in-r/} for details.
Note: one usually needs to alter the keys column which is just populated with all columns.
}
\details{
Please see \code{vignette('DependencySorting', package = 'rquery')} and \code{vignette('joinController', package= 'rquery')} for more details.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  ex <- example_employee_date(my_db)
  print(describe_tables(my_db, ex$tableName,
                         keyInspector = key_inspector_sqlite))
  DBI::dbDisconnect(my_db)
}


}
\seealso{
\code{\link{build_join_plan}}, \code{\link{graph_join_plan}}, \code{\link{actualize_join_plan}}
}
