/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import org.openjena.atlas.io.IndentedWriter;

public abstract class FormatterBase {
    IndentedWriter out;
    SerializationContext context;

    FormatterBase(IndentedWriter _out, SerializationContext _context) {
        this.out = _out;
        this.context = _context;
    }

    public void startVisit() {
    }

    public void finishVisit() {
        this.out.flush();
    }

    protected void formatTriples(BasicPattern pattern) {
        FmtUtils.formatPattern(this.out, pattern, this.context);
    }

    protected void formatTriple(Triple tp) {
        this.out.print(this.slotToString(tp.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getObject()));
    }

    protected String slotToString(Node n) {
        return FmtUtils.stringForNode(n, this.context);
    }
}

