/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main.iterator;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConcat;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;
import org.openjena.atlas.io.IndentedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterUnion
extends QueryIterRepeatApply {
    protected List<Op> subOps;

    public QueryIterUnion(QueryIterator input, List<Op> subOps, ExecutionContext context) {
        super(input, context);
        this.subOps = subOps;
    }

    @Override
    protected QueryIterator nextStage(Binding binding) {
        QueryIterConcat unionQIter = new QueryIterConcat(this.getExecContext());
        for (Op subOp : this.subOps) {
            subOp = QC.substitute(subOp, binding);
            QueryIterSingleton parent = QueryIterSingleton.create(binding, this.getExecContext());
            QueryIterator qIter = QC.execute(subOp, parent, this.getExecContext());
            unionQIter.add(qIter);
        }
        return unionQIter;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Utils.className(this));
        out.incIndent();
        for (Op op : this.subOps) {
            op.output(out, sCxt);
        }
        out.decIndent();
        out.ensureStartOfLine();
    }
}

