% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeDirSample.R
\name{timeDirSample}
\alias{timeDirSample}
\title{timeDirSample}
\usage{
timeDirSample(xy = xy, ot = ot, img = img, rt = rt, mws = NULL,
  dir = NULL, fun = NULL)
}
\arguments{
\item{xy}{Object of class "SpatialPoints" or "SpatialPointsDataFrame".}

\item{ot}{Object of class \emph{Date}, \emph{POSIXlt} or \emph{POSIXct} with \emph{xy} observation dates.}

\item{img}{Object of class \emph{RasterStack} or \emph{RasterBrick}.}

\item{rt}{Object of class \emph{Date}, \emph{POSIXlt} or \emph{POSIXct} with \emph{img} observation dates.}

\item{mws}{Moving window size (expressed in days).}

\item{dir}{One of \emph{fwd}, \emph{bwd} or \emph{both}. Default is \emph{both}.}

\item{fun}{Summary function.}
}
\value{
A \emph{SpatialPointsDataFrame}.
}
\description{
Temporal forward and backward sampling of a raster time series using GPS tracking data.
}
\details{
{This function evaluates how do environmental conditions change in time 
along a movement track. Before an output is returned, the function looks for 
segments of consecutive samples that appear within the same pixel and provides 
mean values for their coordinates and observation times as well as the corresponding 
pixel value and the elapsed time during the segment (in minutes). this step avoids 
the replication of samples while preserving observation related to revisits 
to the same pixels. Then, the function compares the observation times (\emph{ot}) 
of \emph{xy} against the acquisition times (\emph{rt}) of \emph{img} to search for relevant 
information within a pre-defined temporal window (\emph{mws}). The user can chose to 
only consider time steps before (\emph{bwd}) or after (\emph{fwd} the target observation 
time or look at both directios (\emph{both}). If the latest is chosen, the function 
applies \emph{mws} equally to both directions. After selecting adequate temporal 
information, a statistical metric (\emph{fun}) is used to summarize the selected 
time steps. By default, the slope will be used. The slope is estimated from 
a linear regression estimated between the acquisition times of \emph{img} and their 
corresponding values. When providing a new function, set x for time and y for 
the raster values. The output reports on:
\itemize{
 \item{\emph{x} - mean x coordinates}
 \item{\emph{y} - mean y coordinates}
 \item{\emph{timestamp} - mean observation time}
 \item{\emph{pixel.time} - elapsed time within a pixel for a given segment}
 \item{\emph{stat}: statistical metric}
}}
}
\examples{
{
 
 require(raster)
 
 # read movement data
 file <- system.file('extdata', 'konstanz_20130804.shp', package="rsMove")
 moveData <- shapefile(file)
 
 # read raster data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'tc.*tif', full.names=TRUE)
 rsStk <- stack(file)
 rsStk <- stack(rsStk, rsStk, rsStk) # dummy files for the example
 
 # raster dates
 rd = seq.Date(as.Date("2013-08-01"), as.Date("2013-08-09"), 1)
 
 # sample dates
 td = as.Date(moveData@data$date)
 
 # perform directional sampling
 of <- function(x,y) {lm(y~x)$coefficients[2]}
 t.sample <- timeDirSample(xy=moveData, ot=td, img=rsStk, rt=rd, mws=10, dir="bwd", fun=of)
 
}
}
\seealso{
\code{\link{spaceDirSample}} \code{\link{dataQuery}}
}
