% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotMove.R
\name{hotMove}
\alias{hotMove}
\title{hotMove}
\usage{
hotMove(xy = xy, pixel.res = pixel.res, return.shp = FALSE)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} of \emph{SpatialPointsDataFrame}.}

\item{pixel.res}{Grid resolution. Unit depends on \emph{xy} projection.}

\item{return.shp}{Logical. Should the function return polygons of the regions? Default is FALSE.}
}
\value{
List containing a vector of region ID's per data point (\emph{$indices}) and region polygons (\emph{$polygons}).
}
\description{
Detection of geographic regions of samples using a pixel based approach.
}
\details{
{First, the function builds a raster with a resolution equal to \emph{pixel.res} and the
spatial extent of \emph{xy}. Then, each point in \emph{xy} is converted into pixel coordinates. Based
on the unique pixel coordinates, the function then evaluates the spatial connectivity of these pixels
using a 8-neighbor connected component labeling algorithm to detect regions. Finally, the ID's are related
back to each individual data point in \emph{xy} based on their pixel coordinates and - if \emph{return.shp} is TRUE -
 a polygon is derived from the convex hull of the points within each region.}
}
\examples{
{

require(raster)

# reference data
data(longMove)

# extract regions
hm <- hotMove(xy=longMove, pixel.res=0.1, return.shp=TRUE)

# plot shapefile (color by region)
plot(hm$polygons, col=hm$indices)

}
}
\seealso{
\code{\link{sampleMove}} \code{\link{hotMoveStats}}
}
