% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scala.R
\name{scala}
\alias{scala}
\title{Instantiate a Scala Bridge}
\usage{
scala(packages = character(), assign.callback = function(s) { },
  assign.name = "s", JARs = character(),
  serialize.output = .Platform$OS.type == "windows", stdout = TRUE,
  stderr = TRUE, port = 0L, heap.maximum = NULL,
  assign.env = parent.frame(), debug = FALSE)
}
\arguments{
\item{packages}{Character vector of package names whose embedded JAR files
are to be added to the classpath.}

\item{assign.callback}{A function taking a Scala bridge as its only argument.
This function is called immediately after the bridge is connected, which
does not happen until the bridge is actually used and may be long after
this function finishes. This is where setup code goes, like \emph{global}
imports, objects, classes, methods, etc.  For example, it might equal
\code{function(s) { s + 'import scala.util.Random' }}.  \strong{Note} the
use of the execution operator \code{+} instead of the evaluation operator
\code{*}.}

\item{assign.name}{The name of the (promise of the) bridge to be assigned in
the environment given by the \code{assign.env} argument.}

\item{JARs}{Character vector whose elements are individual JAR files to be
added to the runtime classpath.}

\item{serialize.output}{Logical indicating whether Scala output should be
serialized back to R.  This is slower and probably only needed on Windows.}

\item{stdout}{Whether "standard output" results that are not serialized
should be sent.  \code{TRUE} or \code{""} sends output to the \R console
(although that may not work on Windows).  \code{FALSE} or \code{NULL}
discards the output.  Otherwise, this is the name of the file that receives
the output.}

\item{stderr}{Same as \code{stdout}, except influences the "standard error".}

\item{port}{If \code{0}, two random ports are selected.  Otherwise,
\code{port} and \code{port+1} are used to the TCP/IP connections.}

\item{heap.maximum}{String indicating the JVM heap maximum, e.g., "8G".
Without this being set in either \code{\link{scala}} or
\code{\link{scalaHeapMaximum}}, the heap maximum will be 85\% of the
physical RAM.  The value from \code{\link{scalaHeapMaximum}} supersedes
that from \code{\link{scala}}.}

\item{assign.env}{(Developer use only.) The environment in which the (promise
of the) bridge is assigned.}

\item{debug}{(Developer use only.)  Logical indicating whether debugging
should be enabled.}
}
\value{
Returns an rscala bridge.
}
\description{
This function creates an instance of an rscala bridge.
}
\details{
Multiple interpreters can be created and each runs independently with its own
memory space. Each interpreter can use multiple threads/cores, but the bridge
between \R and Scala is itself not thread-safe, so multiple \R threads/cores
should not simultaneously access the same bridge.

Terminate the bridge using \code{\link{close.rscalaBridge}}.

Rather than calling this function explicitly, packages importing or depending
on rscala should instead use the \code{\link{scalaPackage}} and
\code{\link{scalaPackageUnload}} functions.
}
\examples{
\donttest{
scala(assign.name='e')      # Implicitly defines the bridge 'e'.
rng <- e $ .new_scala.util.Random()
rng $ alphanumeric() $ take(15L) $ mkString(',')
e * '2+3'
h <- e(x=2, y=3) ^ 'x+y'
h $ toString()
e(mean=h, sd=2, r=rng) * 'mean + sd * r.nextGaussian()'
close(e)
}

}
\seealso{
\code{\link{close.rscalaBridge}}, \code{\link{scalaPackage}},
  \code{\link{scalaPackageUnload}}, \code{\link{scalaHeapMaximum}}
}
