% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configureApp.R
\name{setProperty}
\alias{setProperty}
\title{Set Application property}
\usage{
setProperty(
  propertyName,
  propertyValue,
  appPath = getwd(),
  appName = NULL,
  account = NULL,
  server = NULL,
  force = FALSE
)
}
\arguments{
\item{propertyName}{Name of property to set}

\item{propertyValue}{Nalue to set property to}

\item{appPath}{Directory or file that was deployed. Defaults to current
working directory.}

\item{appName}{Name of application}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{force}{Forcibly set the property}
}
\description{
Set a property on currently deployed ShinyApps application.
}
\note{
This function only works for ShinyApps servers.
}
\examples{
\dontrun{

# set instance size for an application
setProperty("application.instances.count", 1)

# disable application package cache
setProperty("application.package.cache", FALSE)

}
}
