% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/author_df.R
\name{author_df}
\alias{author_df}
\alias{author_df_orig}
\alias{author_list}
\alias{author_data}
\title{Search Author Content on SCOPUS}
\usage{
author_df(au_id = NULL, last_name = NULL, first_name = NULL,
  api_key = NULL, verbose = TRUE, all_author_info = FALSE,
  http = "https://api.elsevier.com/content/search/scopus",
  view = "COMPLETE", count = 25, general = TRUE, scrub = FALSE,
  ...)

author_df_orig(..., general = FALSE)

author_list(au_id = NULL, last_name = NULL, first_name = NULL,
  api_key = NULL, verbose = TRUE,
  http = "https://api.elsevier.com/content/search/scopus",
  view = "COMPLETE", count = 25, ...)

author_data(..., verbose = TRUE, all_author_info = FALSE,
  general = TRUE, scrub = FALSE)
}
\arguments{
\item{au_id}{Author ID number. Overrides any first/last name argument}

\item{last_name}{last name of author}

\item{first_name}{first name of author}

\item{api_key}{Elsevier API key}

\item{verbose}{Print diagnostic messages}

\item{all_author_info}{Should all author info be recorded instead of
that just to the
author given}

\item{http}{Address for scopus api}

\item{view}{type of view to give, see
\url{https://api.elsevier.com/documentation/ScopusSearchAPI.wadl}}

\item{count}{number of records to retrieve (below 25, see
\url{https://dev.elsevier.com/api_key_settings.html})}

\item{general}{Should \code{\link{gen_entries_to_df}} instead of the
way before version 0.5.10.9001}

\item{scrub}{Should `scrub_identifier` be run on the identifier?}

\item{...}{Arguments to be passed to \code{\link{author_search}}}
}
\value{
List of entries from SCOPUS
}
\description{
Searches SCOPUS to get information about documents
on an author.
Note, \code{author_list} returns a list of the entries from
\code{author_search},
but allows you to put in a name.
}
\note{
The \code{author_data} command will return the list of all
entries as well as
the \code{data.frame}.
}
\examples{
if (have_api_key()) {
res = author_df(last_name = "Muschelli", first_name = "John",
verbose = FALSE)
}
}
\seealso{
\code{\link{get_author_info}}
}
