% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.simsum.R
\name{autoplot.simsum}
\alias{autoplot.simsum}
\title{autoplot method for simsum objects}
\usage{
\method{autoplot}{simsum}(object, type = "forest", stats = "bias",
  target = NULL, fitted = TRUE, scales = "fixed", ...)
}
\arguments{
\item{object}{An object of class \code{simsum}.}

\item{type}{The type of the plot to be produced. Possible choices are: \code{forest}, \code{lolly}, \code{zip}, \code{est}, \code{se}, \code{est_ba}, \code{se_ba}, \code{est_ridge}, \code{se_ridge}, \code{heat}, with \code{forest} being the default.}

\item{stats}{Summary statistic to plot, defaults to \code{bias}. See \code{\link[=summary.simsum]{summary.simsum()}} for further details on supported summary statistics.}

\item{target}{Target of summary statistic, e.g. 0 for \code{bias}. Defaults to \code{NULL}, in which case target will be inferred.}

\item{fitted}{Superimpose a fitted regression line, useful when \code{type} = (\code{est}, \code{se}, \code{est_ba}, \code{se_ba}). Defaults to \code{TRUE}.}

\item{scales}{Should scales be fixed (\code{fixed}, the default), free (\code{free}), or free in one dimension (\code{free_x}, \code{free_y})?}

\item{...}{Not used.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{autoplot} can produce a series of plot to summarise results of simulation studies. See \code{vignette("plotting", package = "rsimsum")} for further details.
}
\examples{
data("MIsim", package = "rsimsum")
s <- rsimsum::simsum(
  data = MIsim, estvarname = "b", true = 0.5, se = "se",
  methodvar = "method", x = TRUE
)

library(ggplot2)
autoplot(s)
autoplot(s, type = "lolly")
}
