% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epochs.R
\name{epochs}
\alias{epochs}
\title{Split signals into consecutive, non-overlaping epochs according to an events dataframe or an epoch duration.}
\usage{
epochs(
  signals,
  sRates,
  resample = max(sRates),
  epoch = 30,
  startTime = 0,
  padding = 0
)
}
\arguments{
\item{signals}{A list of numeric vectors containing signals, or a single vector containing one signal.}

\item{sRates}{A vector or list of integer values of the signals sample rates.}

\item{resample}{The sample rate to resample all signals. Defaults to to the max of the provided sample rates.}

\item{epoch}{Epochs reference. Can be an events dataframe or the number of seconds of each epoc Defaults to 30.}

\item{startTime}{The start timestamp of the signal, used to join events to epoch.}

\item{padding}{Number of previous and next epochs to pad the current epoch with. This functionnality is mostly used to enrich deep learning datasets. Defaults to 0.}
}
\value{
A list of signal chunks
}
\description{
Split long signals into a list of consecutive epochs according to an events dataframe or an epoch duration.
}
\examples{
epochs(list(rep(c(1,2,3,4),100),rep(c(5,6,7,8),100)),4,4,1,padding = 2)
}
