% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancel_print_cleanup.R
\name{print_job_status}
\alias{print_job_status}
\title{Prints the status of a SLURM job and, if completed, its console/error output}
\usage{
print_job_status(slr_job)
}
\arguments{
\item{slr_job}{A \code{slurm_job} object.}
}
\description{
Prints the status of a SLURM job and, if completed, its console/error output.
}
\details{
If the specified SLURM job is still in the queue or running, this function
prints its current status (as output by the SLURM \code{squeue} command).
The output displays one row by node currently running part of the job ("R" in
the "ST" column) and how long it has been running ("TIME"). One row indicates
the portions of the job still in queue ("PD" in the "ST" column), if any.

If all portions of the job have completed or stopped, the function prints the 
console and error output, if any, generated by each node.
}
