% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{pairs.stanreg}
\alias{pairs.stanreg}
\alias{pairs_condition}
\alias{pairs_style_np}
\title{Pairs method for stanreg objects}
\usage{
\method{pairs}{stanreg}(x, pars = NULL, regex_pars = NULL, ...)
}
\arguments{
\item{x}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{pars}{An optional character vetor of parameter names. All parameters 
are included by default, but for models with more than just a few 
parameters it may be far too many to visualize on a small computer screen 
and also may require substantial computing time.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}

\item{...}{Optional arguments passed to \code{\link[bayesplot]{mcmc_pairs}}. 
The \code{np}, \code{lp}, and \code{max_treedepth} arguments to 
\code{mcmc_pairs} are handled automatically by \pkg{rstanarm} and do not 
need to be specified by the user in \code{...}. The arguments that can be 
specified in \code{...} include \code{transformations}, \code{diag_fun},
\code{off_diag_fun}, \code{diag_args}, \code{off_diag_args},
\code{condition}, and \code{np_style}. These arguments are
documented thoroughly on the help page for
\code{\link[bayesplot]{mcmc_pairs}}.}
}
\description{
Interface to \pkg{bayesplot}'s \code{\link[bayesplot]{mcmc_pairs}} function 
for use with \pkg{rstanarm} models. Be careful not to specify too
many parameters to include or the plot will be both hard to read and slow to
render.
}
\details{
By default, the \code{mcmc_pairs} function in the \pkg{bayesplot} package 
plots some of the Markov chains (half, in the case of an even number of
chains) in the panels above the diagonal and the other half in the panels
below the diagonal. This can be changed using the \code{condition} argument
along with the \code{pairs_condition} helper function. 
We provide an example in the \pkg{Examples} section, below, but 
for full details see the \code{\link[bayesplot]{mcmc_pairs}} help page. 
In particular, if when you fit your model \pkg{rstanarm} issues warnings 
about convergence, divergent transitions, or transitions hitting the maximum 
treedepth, then it can sometimes be useful to use one of the NUTS sampler 
parameters/diagnostics for \code{condition}. The last few examples below
demonstrate this feature.
}
\examples{
if (!exists("example_model")) example(example_model)

bayesplot::color_scheme_set("purple")
pairs(example_model, pars = c("(Intercept)", "log-posterior"))
\donttest{
pairs(
  example_model, 
  regex_pars = "herd:[2,7,9]", 
  diag_fun = "dens",
  off_diag_fun = "hex"
)
}

\donttest{
# for demonstration purposes, intentionally fit a model that
# will (almost certainly) have some divergences
fit <- stan_glm(
  mpg ~ ., data = mtcars,
  iter = 1000,
  # this combo of prior and adapt_delta should lead to some divergences
  prior = hs(),
  adapt_delta = 0.9
)

pairs(
  fit, 
  pars = c("wt", "sigma", "log-posterior"), 
  transformations = list(sigma = "log"), # show log(sigma) instead of sigma
  off_diag_fun = "hex" # use hexagonal heatmaps instead of scatterplots
)


bayesplot::color_scheme_set("brightblue")
pairs(
  fit, 
  pars = c("(Intercept)", "wt", "sigma", "log-posterior"), 
  transformations = list(sigma = "log"), 
  off_diag_args = list(size = 3/4, alpha = 1/3), # size and transparency of scatterplot points
  np_style = pairs_style_np(div_color = "black", div_shape = 2) # color and shape of the divergences
)

# Using the condition argument to show divergences above the diagonal 
pairs(
  fit, 
  pars = c("(Intercept)", "wt", "log-posterior"), 
  condition = pairs_condition(nuts = "divergent__")
)

# Using the condition argument to divide iterations by whether NUTS
# accept_stat__ is at least the median accept_stat__ (above diagonal) or less
# than the median accept_stat__ (below diagonal). divergences are still
# marked in red.
pairs(
  fit, 
  pars = c("(Intercept)", "wt", "log-posterior"), 
  condition = pairs_condition(nuts = "accept_stat__")
)
}

}

