% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_check.R
\name{ps_check}
\alias{ps_check}
\title{Graphical checks of the estimated survival function}
\usage{
ps_check(object, check = "survival", limits = c("ci", "none"),
  draws = NULL, seed = NULL, xlab = NULL, ylab = NULL,
  ci_geom_args = NULL, ...)
}
\arguments{
\item{object}{A fitted model object returned by the 
\code{\link{stan_jm}} modelling function. See 
\code{\link{stanreg-objects}}.}

\item{check}{The type of plot to show. Currently only "survival" is 
allowed, which compares the estimated marginal survival function under
the joint model to the estimated Kaplan-Meier curve based on the 
observed data.}

\item{limits}{A quoted character string specifying the type of limits to
include in the plot. Can be one of: \code{"ci"} for the Bayesian
posterior uncertainty interval (often known as a credible interval);
or \code{"none"} for no interval limits.}

\item{draws}{An integer indicating the number of MCMC draws to use to 
to estimate the survival function. The default and maximum number of 
draws is the size of the posterior sample.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}

\item{xlab, ylab}{An optional axis label passed to 
\code{\link[ggplot2]{labs}}.}

\item{ci_geom_args}{Optional arguments passed to 
\code{\link[ggplot2]{geom_ribbon}} and used to control features
of the plotted interval limits. They should be supplied as a named list.}

\item{...}{Optional arguments passed to 
\code{\link[ggplot2]{geom_line}} and used to control features
of the plotted trajectory.}
}
\value{
A ggplot object that can be further customized using the
  \pkg{ggplot2} package.
}
\description{
This function plots the estimated marginal survival function based on draws
from the posterior predictive distribution of the fitted joint model, and then 
overlays the Kaplan-Meier curve based on the observed data.
}
\examples{
\donttest{
if (!exists("example_jm")) example(example_jm)
# Compare estimated survival function to Kaplan-Meier curve
ps <- ps_check(example_jm)
ps + 
 ggplot2::scale_color_manual(values = c("red", "black")) + # change colors
 ggplot2::scale_size_manual(values = c(0.5, 3)) + # change line sizes 
 ggplot2::scale_fill_manual(values = c(NA, NA)) # remove fill
}
}
\seealso{
\code{\link{posterior_survfit}} for the estimated marginal or
  subject-specific survival function based on draws of the model parameters
  from the posterior distribution, 
  \code{\link{posterior_predict}} for drawing from the posterior 
  predictive distribution for the longitudinal submodel, and 
  \code{\link{pp_check}} for graphical checks of the longitudinal submodel.
}

