% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanmvreg-methods.R
\name{stanmvreg-methods}
\alias{coef.stanmvreg}
\alias{fitted.stanmvreg}
\alias{fixef.stanmvreg}
\alias{formula.stanmvreg}
\alias{ngrps.stanmvreg}
\alias{ranef.stanmvreg}
\alias{residuals.stanmvreg}
\alias{se.stanmvreg}
\alias{sigma.stanmvreg}
\alias{stanmvreg-methods}
\alias{update.stanjm}
\alias{update.stanmvreg}
\title{Methods for stanmvreg objects}
\usage{
\method{coef}{stanmvreg}(object, m = NULL, ...)

\method{fitted}{stanmvreg}(object, m = NULL, ...)

\method{residuals}{stanmvreg}(object, m = NULL, ...)

\method{se}{stanmvreg}(object, m = NULL, ...)

\method{formula}{stanmvreg}(x, fixed.only = FALSE, random.only = FALSE,
  m = NULL, ...)

\method{update}{stanmvreg}(object, formula., ..., evaluate = TRUE)

\method{update}{stanjm}(object, formulaLong., formulaEvent., ...,
  evaluate = TRUE)

\method{fixef}{stanmvreg}(object, m = NULL, remove_stub = TRUE, ...)

\method{ngrps}{stanmvreg}(object, ...)

\method{ranef}{stanmvreg}(object, m = NULL, ...)

\method{sigma}{stanmvreg}(object, m = NULL, ...)
}
\arguments{
\item{object, x}{A fitted model object returned by one of the 
multivariate \pkg{rstanarm} modelling functions. See 
\code{\link{stanreg-objects}}.}

\item{m}{Integer specifying the number or name of the submodel}

\item{...}{Ignored, except by the \code{update} method. See
\code{\link{update}}.}

\item{fixed.only}{A logical specifying whether to only retain the fixed effect
part of the longitudinal submodel formulas}

\item{random.only}{A logical specifying whether to only retain the random effect
part of the longitudinal submodel formulas}

\item{formula.}{An updated formula for the model. For a multivariate model
\code{formula.} should be a list of formulas, as described for the 
\code{formula} argument in \code{\link{stan_mvmer}}.}

\item{evaluate}{See \code{\link[stats]{update}}.}

\item{formulaLong., formulaEvent.}{An updated formula for the longitudinal
or event submodel, when \code{object} was estimated using 
\code{\link{stan_jm}}. For a multivariate joint model \code{formulaLong.} 
should be a list of formulas, as described for the \code{formulaLong}
argument in \code{\link{stan_jm}}.}

\item{remove_stub}{Logical specifying whether to remove the string identifying 
the submodel (e.g. \code{y1|}, \code{y2|}, \code{Long1|}, \code{Long2|},
\code{Event|}) from each of the parameter names.}
}
\description{
S3 methods for \link[=stanreg-objects]{stanmvreg} objects. There are also 
several methods (listed in \strong{See Also}, below) with their own
individual help pages. 
The main difference between these methods and the 
\link[=stanreg-methods]{stanreg} methods is that the methods described here
generally include an additional argument \code{m} which allows the user to
specify which submodel they wish to return the result for. If the argument
\code{m} is set to \code{NULL} then the result will generally be a named list
with each element of the list containing the result for one of the submodels.
}
\details{
Most of these methods are similar to the methods defined for objects
  of class 'lm', 'glm', 'glmer', etc. However there are a few exceptions:
  
\describe{
\item{\code{coef}}{
Medians are used for point estimates. See the \emph{Point estimates} section
in \code{\link{print.stanmvreg}} for more details. \code{coef} returns a list 
equal to the length of the number of submodels. The first
elements of the list are the coefficients from each of the fitted longitudinal
submodels and are the same layout as those returned by \code{coef} method of the
\pkg{lme4} package, that is, the sum of the random and fixed effects coefficients 
for each explanatory variable for each level of each grouping factor. The final
element of the returned list is a vector of fixed effect coefficients from the
event submodel. 
}
\item{\code{se}}{
The \code{se} function returns standard errors based on 
\code{\link{mad}}. See the \emph{Uncertainty estimates} section in
\code{\link{print.stanmvreg}} for more details.
}
\item{\code{confint}}{
Not supplied, since the \code{\link{posterior_interval}} function should 
be used instead to compute Bayesian uncertainty intervals.
}
\item{\code{residuals}}{
Residuals are \emph{always} of type \code{"response"} (not \code{"deviance"}
residuals or any other type).
}
}
}
\seealso{
\itemize{
 \item The \code{\link[=print.stanmvreg]{print}},
   \code{\link[=summary.stanmvreg]{summary}}, and \code{\link{prior_summary}} 
   methods for \code{stanmvreg} objects for information on the fitted model.
 \item The \code{\link[=plot.stanreg]{plot}} method to plot estimates and
   diagnostics.
 \item The \code{\link{pp_check}} method for graphical posterior predictive
   checking of the longitudinal or glmer submodels.
 \item The \code{\link{ps_check}} method for graphical posterior predictive
   checking of the event submodel.
 \item The \code{\link{posterior_traj}} for predictions for the longitudinal
   submodel (for models estimated using \code{\link{stan_jm}}), as well as
   it's associated \code{\link[=plot.predict.stanjm]{plot}} method.
 \item The \code{\link{posterior_survfit}} for predictions for the event
   submodel, including so-called "dynamic" predictions (for models estimated 
   using \code{\link{stan_jm}}), as well as
   it's associated \code{\link[=plot.survfit.stanjm]{plot}} method.
 \item The \code{\link{posterior_predict}} for predictions for the glmer
   submodel (for models estimated using \code{\link{stan_mvmer}}).
 \item The \code{\link{posterior_interval}} for uncertainty intervals for 
   model parameters.
 \item The \code{\link[=loo.stanreg]{loo}}, 
   and \code{\link[=log_lik.stanmvreg]{log_lik}} methods for leave-one-out 
   model comparison, and computing the log-likelihood of (possibly new) data.
 \item The \code{\link[=as.matrix.stanreg]{as.matrix}}, \code{as.data.frame}, 
   and \code{as.array} methods to access posterior draws.
} 

Other S3 methods for stanmvreg objects, which have separate documentation, 
including \code{\link{print.stanmvreg}}, and \code{\link{summary.stanmvreg}}.

Also \code{\link{posterior_interval}} for an alternative to \code{confint}, 
and \code{posterior_predict}, \code{posterior_traj} and 
\code{posterior_survfit} for predictions based on the fitted joint model.
}

