% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test.R
\name{chisq_test}
\alias{chisq_test}
\alias{pairwise_chisq_gof_test}
\alias{pairwise_chisq_test_against_p}
\alias{chisq_descriptives}
\alias{expected_freq}
\alias{observed_freq}
\alias{pearson_residuals}
\alias{std_residuals}
\title{Chi-squared Test for Count Data}
\usage{
chisq_test(x, y = NULL, correct = TRUE, p = rep(1/length(x),
  length(x)), rescale.p = FALSE, simulate.p.value = FALSE, B = 2000)

pairwise_chisq_gof_test(x, p.adjust.method = "holm", ...)

pairwise_chisq_test_against_p(x, p = rep(1/length(x), length(x)),
  p.adjust.method = "holm", ...)

chisq_descriptives(res.chisq)

expected_freq(res.chisq)

observed_freq(res.chisq)

pearson_residuals(res.chisq)

std_residuals(res.chisq)
}
\arguments{
\item{x}{a numeric vector or matrix. \code{x} and \code{y} can also
    both be factors.}

\item{y}{a numeric vector; ignored if \code{x} is a matrix.  If
    \code{x} is a factor, \code{y} should be a factor of the same length.}

\item{correct}{a logical indicating whether to apply continuity
    correction when computing the test statistic for 2 by 2 tables: one
    half is subtracted from all \eqn{|O - E|} differences; however, the
    correction will not be bigger than the differences themselves.  No correction
    is done if \code{simulate.p.value = TRUE}.}

\item{p}{a vector of probabilities of the same length of \code{x}.
    An error is given if any entry of \code{p} is negative.}

\item{rescale.p}{a logical scalar; if TRUE then \code{p} is rescaled
    (if necessary) to sum to 1.  If \code{rescale.p} is FALSE, and
    \code{p} does not sum to 1, an error is given.}

\item{simulate.p.value}{a logical indicating whether to compute
    p-values by Monte Carlo simulation.}

\item{B}{an integer specifying the number of replicates used in the
    Monte Carlo test.}

\item{p.adjust.method}{method to adjust p values for multiple comparisons.
Used when pairwise comparisons are performed. Allowed values include "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't
want to adjust the p value (not recommended), use p.adjust.method = "none".}

\item{...}{other arguments passed to the function \code{{chisq_test}()}.}

\item{res.chisq}{an object of class \code{chisq_test}.}
}
\value{
return a data frame with some the following columns: \itemize{ \item
 \code{n}: the number of participants. \item \code{group, group1, group2}:
 the categories or groups being compared. \item \code{statistic}: the value
 of Pearson's chi-squared test statistic. \item \code{df}: the degrees of
 freedom of the approximate chi-squared distribution of the test statistic.
 NA if the p-value is computed by Monte Carlo simulation. \item \code{p}:
 p-value. \item \code{p.adj}: the adjusted p-value. \item \code{method}: the
 used statistical test. \item \code{p.signif, p.adj.signif}: the significance
 level of p-values and adjusted p-values, respectively. \item
 \code{observed}: observed counts. \item
 \code{expected}: the expected counts under the null hypothesis.
 }
 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments.
}
\description{
Performs chi-squared tests, including goodness-of-fit,
 homogeneity and independence tests.
}
\section{Functions}{
\itemize{
\item \code{chisq_test}: performs chi-square tests including goodness-of-fit,
homogeneity and independence tests.

\item \code{pairwise_chisq_gof_test}: perform pairwise comparisons between groups following a global
chi-square goodness of fit test.

\item \code{pairwise_chisq_test_against_p}: perform pairwise comparisons after a global
chi-squared test for given probabilities. For each group, the observed and
the expected proportions are shown. Each group is compared to the sum of
all others.

\item \code{chisq_descriptives}: returns the descriptive statistics of the chi-square
test. These include, observed and expected frequencies, proportions,
residuals and standardized residuals.

\item \code{expected_freq}: returns the expected counts from the chi-square test result.

\item \code{observed_freq}: returns the observed counts from the chi-square test result.

\item \code{pearson_residuals}: returns the Pearson residuals, \code{(observed - expected) / sqrt(expected)}.

\item \code{std_residuals}: returns the standardized residuals
}}

\examples{
# Chi-square goodness of fit test
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
tulip <- c(red = 81, yellow = 50, white = 27)
# Q1: Are the colors equally common?
chisq_test(tulip)
pairwise_chisq_gof_test(tulip)
# Q2: comparing observed to expected proportions
chisq_test(tulip, p = c(1/2, 1/3, 1/6))
pairwise_chisq_test_against_p(tulip, p = c(1/2, 1/3, 1/6))

# Homogeneity of proportions between groups
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Data: Titanic
xtab <- as.table(rbind(
  c(203, 118, 178, 212),
  c(122, 167, 528, 673)
))
dimnames(xtab) <- list(
  Survived = c("Yes", "No"),
  Class = c("1st", "2nd", "3rd", "Crew")
)
xtab
# Chi-square test
chisq_test(xtab)
# Compare the proportion of survived between groups
pairwise_prop_test(xtab)
}
