% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_triangle.R
\name{pull_triangle}
\alias{pull_triangle}
\alias{pull_upper_triangle}
\alias{pull_lower_triangle}
\title{Pull Lower and Upper Triangular Part of a Matrix}
\usage{
pull_triangle(x, triangle = c("lower", "upper"), diagonal = FALSE)

pull_upper_triangle(x, diagonal = FALSE)

pull_lower_triangle(x, diagonal = FALSE)
}
\arguments{
\item{x}{a (correlation) matrix}

\item{triangle}{the triangle to pull. Allowed values are one of
"upper" and "lower".}

\item{diagonal}{logical. Default is FALSE. If TRUE, the matrix diagonal is
included.}
}
\value{
an object of class \code{cor_mat_tri}, which is a data frame
}
\description{
Returns the lower or the upper triangular part of a
  (correlation) matrix.
}
\section{Functions}{
\itemize{
\item \code{pull_triangle}: returns either the lower or upper triangular part of a matrix.

\item \code{pull_upper_triangle}: returns an object of class \code{upper_tri}, which
is a data frame containing the upper triangular part of a matrix.

\item \code{pull_lower_triangle}: returns an object of class \code{lower_tri}, which
is a data frame containing the lower triangular part of a matrix.
}}

\examples{

# Data preparation
#::::::::::::::::::::::::::::::::::::::::::
mydata <- mtcars \%>\%
  select(mpg, disp, hp, drat, wt, qsec)
head(mydata, 3)

# Compute correlation matrix and pull triangles
#::::::::::::::::::::::::::::::::::::::::::
# Correlation matrix
cor.mat <- cor_mat(mydata)
cor.mat

# Pull lower triangular part
cor.mat \%>\% pull_lower_triangle()

# Pull upper triangular part
cor.mat \%>\% pull_upper_triangle()


}
\seealso{
\code{\link{replace_triangle}()}
}
