/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataRecordIteration;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.SGStatisticsBuilder;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.search.SDMethod;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.NumericSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.NumericTarget;

public class NumericBSD
extends SDMethod {
    private final String NAME = "Numeric BitSetSD";
    private static final boolean SORT = true;
    private NumericTarget target;
    private double totalPopulationSize;
    private double popMean;
    private Map<SGSelector, BitSet> selectorsBitSet;
    List<DataRecord> sortedDataRecords;
    double[] targetValues;
    private BitSet allTrue;
    private KBestSGSet result;
    private SGDescription initialSGDescription;

    @Override
    public String getName() {
        return "Numeric BitSetSD";
    }

    private List<SGSelector> getAllRelevantSelectors() {
        ArrayList<SGSelector> arrayList = new ArrayList<SGSelector>(this.selectorsBitSet.keySet());
        Collections.sort(arrayList, new Comparator<SGSelector>(){

            @Override
            public int compare(SGSelector o1, SGSelector o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return arrayList;
    }

    @Override
    protected SGSet search(SG initialSubgroup) {
        this.initialize(initialSubgroup);
        if (this.getMethodStats() != null) {
            this.getMethodStats().setNodeCounter(0);
        }
        KBestSGSet result = this.mineBitSets();
        return result;
    }

    private KBestSGSet mineBitSets() {
        this.mineBitSets((BitSet)this.allTrue.clone(), 0, new Stack<SGSelector>(), this.getAllRelevantSelectors());
        return this.result;
    }

    private void mineBitSets(BitSet currentBitSet, int depth, List<SGSelector> currentSelectors, List<SGSelector> relevantSelectors) {
        if (this.isAborted()) {
            return;
        }
        ArrayList<SelectorEstimate> optimisticEstimates = new ArrayList<SelectorEstimate>();
        ArrayList<SGSelector> newRelevantSelectors = new ArrayList<SGSelector>();
        for (SGSelector newSelector : relevantSelectors) {
            double optEstimatedQuality;
            int n;
            BitSet nextBitSet = (BitSet)currentBitSet.clone();
            nextBitSet.and(this.selectorsBitSet.get(newSelector));
            if (this.task.isSuppressStrictlyIrrelevantSubgroups() && nextBitSet.equals(currentBitSet) || !((double)(n = nextBitSet.cardinality()) >= this.task.getMinSubgroupSize())) continue;
            double tp = this.sumUpTargetValues(nextBitSet);
            ArrayList<SGSelector> newSelectors = new ArrayList<SGSelector>();
            newSelectors.addAll(currentSelectors);
            newSelectors.add(newSelector);
            if (this.getMethodStats() != null) {
                this.getMethodStats().increaseNodeCounter();
            }
            SG sg = new SG(this.getPopulation(), this.target);
            SGStatisticsBuilder.createSGStatisticsNumeric(sg, tp, this.popMean, n, this.totalPopulationSize);
            sg.updateQuality(this.task.getQualityFunction());
            if (this.result.isInKBestQualityRange(sg.getQuality())) {
                SGDescription newSGD = this.initialSGDescription.clone();
                newSGD.addAll(newSelectors);
                sg.setSGDescription(newSGD);
                if (!this.task.isSuppressStrictlyIrrelevantSubgroups() || !SGSets.isSGStrictlyIrrelevant(sg, this.result)) {
                    this.addSubgroupToSGSet(this.result, sg);
                }
            }
            if (!this.result.isInKBestQualityRange(optEstimatedQuality = Double.MAX_VALUE)) continue;
            SelectorEstimate currentSelEstimate = new SelectorEstimate(newSelector, optEstimatedQuality, newSelectors, nextBitSet);
            optimisticEstimates.add(currentSelEstimate);
            newRelevantSelectors.add(newSelector);
        }
        if (depth + 1 < this.task.getMaxSGDSize()) {
            Collections.sort(optimisticEstimates);
            for (SelectorEstimate estimate : optimisticEstimates) {
                if (!this.result.isInKBestQualityRange(estimate.estimate)) {
                    newRelevantSelectors.remove(estimate.sel);
                    continue;
                }
                newRelevantSelectors.remove(estimate.sel);
                ArrayList<SGSelector> relevantForThisSelector = new ArrayList<SGSelector>();
                for (SGSelector sel : newRelevantSelectors) {
                    boolean allowsForMultipleSelectorsPerAttribute;
                    boolean bl = allowsForMultipleSelectorsPerAttribute = sel instanceof NegatedSGSelector || sel instanceof NumericSelector;
                    if (!allowsForMultipleSelectorsPerAttribute && sel.getAttribute() == estimate.sel.getAttribute()) continue;
                    relevantForThisSelector.add(sel);
                }
                if (relevantForThisSelector.isEmpty()) continue;
                this.mineBitSets(estimate.bitSet, depth + 1, estimate.allSelectors, relevantForThisSelector);
            }
        }
    }

    private double sumUpTargetValues(BitSet bs) {
        double result = 0.0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            result += this.targetValues[i];
            i = bs.nextSetBit(i + 1);
        }
        return result;
    }

    private void initializeBitSets(SG initialSubgroup) {
        DataRecordIteration iteration = new DataRecordIteration(initialSubgroup.subgroupInstanceIterator());
        this.sortedDataRecords = DiscretizationUtils.getSortedDataRecords(iteration, this.target.getAttribute(), false, true);
        this.createAllTrueBitSet();
        this.createTargetValues();
        this.selectorsBitSet = new HashMap<SGSelector, BitSet>();
        for (SGSelector sel : this.getSelectorSet(initialSubgroup, this.target)) {
            if (this.isAborted()) {
                return;
            }
            this.createBitSets(sel, this.sortedDataRecords, iteration.size());
        }
    }

    private void createTargetValues() {
        this.targetValues = new double[this.sortedDataRecords.size()];
        int i = 0;
        for (DataRecord dr : this.sortedDataRecords) {
            this.targetValues[i++] = this.target.getValue(dr);
        }
    }

    private void createAllTrueBitSet() {
        this.allTrue = new BitSet(this.sortedDataRecords.size());
        int i = 0;
        while (i < this.sortedDataRecords.size()) {
            this.allTrue.set(i);
            ++i;
        }
    }

    private void createBitSets(SGSelector sel, Iterable<DataRecord> iteration, int size) {
        BitSet selectorBitSet = new BitSet(size);
        int i = 0;
        for (DataRecord dr : iteration) {
            if (sel.isContainedInInstance(dr)) {
                selectorBitSet.set(i);
            }
            ++i;
        }
        this.selectorsBitSet.put(sel, selectorBitSet);
    }

    private void initialize(SG initialSubgroup) {
        if (!initialSubgroup.getTarget().isNumeric()) {
            throw new IllegalArgumentException("Algorithm not appropriate for boolean targets");
        }
        this.target = (NumericTarget)initialSubgroup.getTarget();
        SGStatisticsNumeric stats = (SGStatisticsNumeric)initialSubgroup.getStatistics();
        this.totalPopulationSize = stats.getDefinedPopulationCount();
        this.popMean = stats.getPopulationMean();
        this.result = SGSets.createKBestSGSet(this.task.getMaxSGCount(), this.task.getMinQualityLimit());
        this.initialSGDescription = initialSubgroup.getSGDescription();
        this.initializeBitSets(initialSubgroup);
    }

    @Override
    public boolean isTreatMissingAsUndefinedSupported() {
        return false;
    }

    private static class SelectorEstimate
    implements Comparable<SelectorEstimate> {
        private final SGSelector sel;
        private final double estimate;
        private final List<SGSelector> allSelectors;
        private final BitSet bitSet;

        public SelectorEstimate(SGSelector sel, double estimate, List<SGSelector> allSelectors, BitSet bitset) {
            this.sel = sel;
            this.estimate = estimate;
            this.allSelectors = allSelectors;
            this.bitSet = bitset;
        }

        @Override
        public int compareTo(SelectorEstimate o) {
            return -Double.compare(this.estimate, o.estimate);
        }

        public String toString() {
            return this.sel + ": " + this.estimate;
        }
    }
}

