% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfrailty.R
\name{rfrailty}
\alias{rfrailty}
\title{Frailties random generation}
\usage{
rfrailty(
  cluster,
  frailty = c("gamma", "gaussian", "ps"),
  sigma = 1,
  alpha = NULL,
  ...
)
}
\arguments{
\item{cluster}{the variable to be entered as a random effect (always converted to a factor object internally).}

\item{frailty}{the frailty distribution; current implementation includes the gamma (default), lognormal and positive stable (ps) distributions.}

\item{sigma}{standard deviation assumed for the frailty distribution; sigma = 1 by default; this value is ignored for positive stable (ps) distribution.}

\item{alpha}{stability parameter of the positive stable distribution; alpha must lie in (0,1) interval and an NA is return otherwise.}

\item{...}{further arguments passed to other methods.}
}
\value{
a vector with the generated frailties.
}
\description{
The frailty function for adding a simple random effects term to the linear predictor of a given survival regression model.
}
