% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcorplot.R
\name{ggcorplot}
\alias{ggcorplot}
\title{Variables factor map for \code{\link[rsvd]{rpca}} using \code{\link[ggplot2]{ggplot}}.}
\usage{
ggcorplot(rpcaObj, pcs = c(1, 2), loadings = TRUE,
  var_labels = FALSE, var_labels.names = NULL, alpha = 1,
  top.n = NULL)
}
\arguments{
\item{rpcaObj}{Object returned by the \code{\link[rsvd]{rpca}} function.}

\item{pcs}{Array_like. \cr
An array with two values indicating the two PCs which should be used for plotting. 
By default the first two PCs are used, e.g., \eqn{c(1,2)}.}

\item{loadings}{Bool (\eqn{TRUE}, \eqn{FALSE}), optional. \cr
If \eqn{TRUE}, the eigenvectors
are unit scaled by the square root of the eigenvalues \eqn{W = W * diag(sqrt(eigvals))}.}

\item{var_labels}{Bool (\eqn{TRUE}, \eqn{FALSE}), optional. \cr
Plot variable names, if \eqn{TRUE}.}

\item{var_labels.names}{Array_like, optional. \cr
User specific labels for the variables}

\item{alpha}{Scalar, optional. \cr
Alpha transparency of the arrows.}

\item{top.n}{Scalar, optional. \cr
Number of (most influencial) variables to label with small circles.}

\item{.................}{.}
}
\description{
Creates a pretty plot which is showing the correlation of
   the original variable with the principal component (PCs).
}
\examples{
#

}
\seealso{
\code{\link[rsvd]{rpca}}, \code{\link[ggplot2]{ggplot}}
}
\author{
N. Benjamin Erichson, \email{erichson@berkeley.edu}
}
