% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggindplot.R
\name{ggindplot}
\alias{ggindplot}
\title{Individual factor map for \code{\link[rsvd]{rpca}} using \code{\link[ggplot2]{ggplot}}.}
\usage{
ggindplot(rpcaObj, pcs = c(1, 2), groups = NULL, alpha = 0.6,
  ellipse = TRUE, alpha.ellipse = 0.2, ind_labels = TRUE,
  ind_labels.names = NULL)
}
\arguments{
\item{rpcaObj}{Object returned by the \code{\link[rsvd]{rpca}} function.}

\item{pcs}{Array_like. \cr
An array with two values indicating the two PCs which should be used for plotting. 
By default the first two PCs are used, e.g., \eqn{c(1,2)}.}

\item{groups}{Factor, optional. \cr
Factor indicating groups.}

\item{alpha}{Scalar, optional. \cr
Alpha transparency for scatter plot.}

\item{ellipse}{Bool (\eqn{TRUE}, \eqn{FALSE}), optional. \cr
Draw a 1sd data ellipse for each group, if \eqn{TRUE}.}

\item{alpha.ellipse}{Scalar, optional. \cr
Alpha transparency for ellipse.}

\item{ind_labels}{Bool (\eqn{TRUE}, \eqn{FALSE}), optional. \cr
Plot names for each individual point, if \eqn{TRUE}.}

\item{ind_labels.names}{Array_like, optional. \cr
User specific labels for the individual points.}
}
\description{
Creates a pretty plot which is showing the individual factor map, i.e,
   plotting the principal component scores.
}
\examples{
#See ?rpca
}
\seealso{
\code{\link[rsvd]{rpca}}, \code{\link[ggplot2]{ggplot}}
}
\author{
N. Benjamin Erichson, \email{erichson@berkeley.edu}
}
